/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Info;
import io.imply.cloud.util.Logger;

public class SetConfigServerClusterVersionStage
extends BaseStage {
    private static final Logger log = new Logger(SetConfigServerClusterVersionStage.class);
    private final Integer configServerClusterVersion;

    @JsonCreator
    public SetConfigServerClusterVersionStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="configServerClusterVersion") Integer configServerClusterVersion) {
        super(toolbox, clusterId);
        this.configServerClusterVersion = configServerClusterVersion;
    }

    @Override
    public boolean innerRun() {
        Info info = this.getInfo();
        log.info("Changing cluster version used by config server from [%d] to [%d]", new Object[]{info.getConfigServerClusterVersion(), this.configServerClusterVersion});
        this.toolbox.getEntityStateDataManager().insert(info, Info.builder().withConfigServerClusterVersion(this.configServerClusterVersion).build());
        return true;
    }

    @JsonProperty
    public Integer getConfigServerClusterVersion() {
        return this.configServerClusterVersion;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 5;
    }

    @JsonProperty
    public String getDescription() {
        return "Requesting configuration server to use new cluster configuration";
    }
}

