/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.druid.TaskPayload;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RetryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RolloverStreamingTasksOnMiddleManagerStage
extends MasterHostsStage {
    private static final Logger log = new Logger(RolloverStreamingTasksOnMiddleManagerStage.class);
    private final String host;
    private final Set<String> masterHosts;

    @JsonCreator
    public RolloverStreamingTasksOnMiddleManagerStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="host") String host, @JsonProperty(value="masterHosts") Set<String> masterHosts) {
        super(toolbox, clusterId);
        this.host = host;
        this.masterHosts = masterHosts;
    }

    @Override
    public boolean innerRun() {
        log.info("Triggering early handoff of streaming tasks on mm [%s]", new Object[]{this.host});
        try {
            List runningTasksOnMM = this.toolbox.getDruidApiClient().getMiddleManagerTasks(this.host, this.getClusterId());
            ArrayList<String> masterHostsList = new ArrayList<String>(this.findMasterHosts());
            HashMap tasksToHandoff = new HashMap();
            for (String string : runningTasksOnMM) {
                TaskPayload taskPayload = this.toolbox.getDruidApiClient().getTaskPayload(this.getClusterId(), masterHostsList, string).getPayload();
                if (!taskPayload.getType().equals("index_kafka") && !taskPayload.getType().equals("index_kinesis")) continue;
                if (tasksToHandoff.containsKey(taskPayload.getDataSource())) {
                    ((List)tasksToHandoff.get(taskPayload.getDataSource())).add(taskPayload.getIoConfig().getTaskGroupId());
                    continue;
                }
                tasksToHandoff.put(taskPayload.getDataSource(), new ArrayList(ImmutableList.of((Object)taskPayload.getIoConfig().getTaskGroupId())));
            }
            for (Map.Entry entry : tasksToHandoff.entrySet()) {
                RetryUtils.retry(() -> this.toolbox.getDruidApiClient().handoffSupervisorTasksEarly(this.getClusterId(), masterHostsList, (String)entryPair.getKey(), (List)entryPair.getValue()), t -> t instanceof IllegalStateException, (int)3);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to trigger early handoff for running streaming tasks on mm [%s]. continuing.", new Object[]{this.host});
        }
        return true;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Triggering early handoff of streaming tasks on mm [%s]", this.host);
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 15;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getExecutionDelayInSeconds() {
        return this.toolbox.getApplicationConfig().getEarlyHandoffDelay();
    }
}

