/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.druid.LoadRule;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemapLoadRulesStage
extends MasterHostsStage {
    @Generated
    private static final Logger log = Logger.from(RemapLoadRulesStage.class);
    private final Set<String> masterHosts;
    private final String auditAuthor;
    private final String auditComment;
    private final Map<Integer, InstanceTier> currentTiers;
    private final Map<Integer, InstanceTier> desiredTiers;
    private final Boolean clusterCreating;

    @JsonCreator
    public RemapLoadRulesStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="masterHosts") Set<String> masterHosts, @JsonProperty(value="currentTiers") Map<Integer, InstanceTier> currentTiers, @JsonProperty(value="desiredTiers") Map<Integer, InstanceTier> desiredTiers, @JsonProperty(value="clusterCreating") Boolean clusterCreating, @JsonProperty(value="auditAuthor") String auditAuthor, @JsonProperty(value="auditComment") String auditComment) {
        super(toolbox, clusterId, nodeType);
        this.masterHosts = masterHosts;
        this.auditAuthor = auditAuthor;
        this.auditComment = auditComment;
        this.currentTiers = currentTiers;
        this.desiredTiers = desiredTiers;
        this.clusterCreating = clusterCreating;
    }

    @Override
    public boolean innerRun() {
        try {
            Set<String> masterHosts = this.findMasterHosts();
            this.getAffectedLoadRules(masterHosts).entrySet().stream().map(this::remapLoadRules).forEach(pair -> this.setLoadRule((Pair<String, List<LoadRule>>)pair, masterHosts));
        }
        catch (IllegalStateException e) {
            log.info("ISE while remapping load rules, master servers may be temporarily down: %s", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    private Map<String, List<LoadRule>> getAffectedLoadRules(Set<String> masterHosts) {
        Map loadRules = this.toolbox.getDruidApiClient().getLoadRules(masterHosts, this.getClusterId());
        return loadRules.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(rule -> MapUtils.isNotEmpty((Map)rule.getTieredReplicants()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void setLoadRule(Pair<String, List<LoadRule>> pair, Set<String> masterHosts) {
        this.toolbox.getDruidApiClient().setLoadRuleConfiguration(masterHosts, (String)pair.lhs, (List)pair.rhs, this.getClusterId(), this.getAuditAuthor(), this.getAuditComment());
    }

    Pair<String, List<LoadRule>> remapLoadRules(Map.Entry<String, List<LoadRule>> rules) {
        return Pair.of((Object)rules.getKey(), rules.getValue().stream().map(this::maybeRemapLoadRule).collect(Collectors.toList()));
    }

    @VisibleForTesting
    protected LoadRule maybeRemapLoadRule(LoadRule rule) {
        if (MapUtils.isEmpty((Map)rule.getTieredReplicants())) {
            return rule;
        }
        HashMap tieredReplicantMap = new HashMap(rule.getTieredReplicants());
        Set<String> desiredDeployedTiers = this.getDeployedTierNames(this.getDesiredTiers());
        Set<String> currentDeployedTiers = this.getDeployedTierNames(this.getCurrentTiers());
        this.getDesiredTiers().entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).forEach(e -> {
            int currentTierNumber = (Integer)e.getKey();
            int otherTierNumber = currentTierNumber % 2 == 0 ? currentTierNumber - 1 : currentTierNumber + 1;
            String currentTier = this.getTierName(currentTierNumber);
            String otherTier = this.getTierName(otherTierNumber);
            if (!this.getClusterCreating().booleanValue() && tieredReplicantMap.containsKey(currentTier)) {
                return;
            }
            if (!this.getClusterCreating().booleanValue() && tieredReplicantMap.containsKey(otherTier)) {
                tieredReplicantMap.put(currentTier, (Integer)tieredReplicantMap.get(otherTier));
            } else {
                tieredReplicantMap.put(currentTier, 1);
            }
        });
        Map<String, Integer> filteredTieredReplicantMap = tieredReplicantMap.entrySet().stream().filter(e -> desiredDeployedTiers.contains(e.getKey()) || currentDeployedTiers.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return rule.toBuilder().tieredReplicants(filteredTieredReplicantMap).build();
    }

    protected Set<String> getDeployedTierNames(Map<Integer, InstanceTier> tiers) {
        return MapUtils.emptyIfNull(tiers).entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).map(e -> ((InstanceTier)e.getValue()).getName()).collect(Collectors.toSet());
    }

    protected String getTierName(Integer tierNumber) {
        if (tierNumber.equals(1)) {
            return "_default_tier";
        }
        return String.format("_tier%d", tierNumber);
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @JsonProperty
    public String getAuditAuthor() {
        return this.auditAuthor;
    }

    @JsonProperty
    public String getAuditComment() {
        return this.auditComment;
    }

    @JsonProperty
    public Map<Integer, InstanceTier> getCurrentTiers() {
        return this.currentTiers;
    }

    @JsonProperty
    public Map<Integer, InstanceTier> getDesiredTiers() {
        return this.desiredTiers;
    }

    @JsonProperty
    public Boolean getClusterCreating() {
        return this.clusterCreating;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 20;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Remapping load rule configurations, current tiers: %s, deployed tiers: %s", this.getDeployedTierNames(this.currentTiers), this.getDeployedTierNames(this.desiredTiers));
    }
}

