/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ModifyOverlordDynamicConfigurationWithDetectedMasterStage
extends BaseStage {
    private static final Logger log = new Logger(ModifyOverlordDynamicConfigurationWithDetectedMasterStage.class);
    private final String configurationData;
    private final String auditAuthor;
    private final String auditComment;
    private final boolean merge;

    @JsonCreator
    public ModifyOverlordDynamicConfigurationWithDetectedMasterStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="configurationData") String configurationData, @JsonProperty(value="auditAuthor") String auditAuthor, @JsonProperty(value="auditComment") String auditComment, @JsonProperty(value="merge") boolean merge) {
        super(toolbox, clusterId, nodeType);
        this.configurationData = configurationData;
        this.auditAuthor = auditAuthor;
        this.auditComment = auditComment;
        this.merge = merge;
    }

    @Override
    public boolean innerRun() throws Exception {
        log.info("Setting overlord dynamic configuration to [%s]", new Object[]{this.configurationData});
        List masterHosts = this.toolbox.getClusterNodesHelper().getSortedMasterHosts(this.getClusterId());
        try {
            Optional<Object> updatedConfig = Optional.empty();
            if (this.merge) {
                String config = this.toolbox.getDruidApiClient().getOverlordDynamicConfiguration((Collection)masterHosts, this.getClusterId());
                Map currentConfig = (Map)this.toolbox.getObjectMapper().readValue((String)StringUtils.defaultIfEmpty((CharSequence)config, (CharSequence)"{}"), Constants.MAP_TYPE);
                updatedConfig = Optional.of((Map)this.toolbox.getObjectMapper().readerForUpdating((Object)currentConfig).readValue(this.configurationData));
            }
            this.toolbox.getDruidApiClient().setOverlordDynamicConfiguration((Collection)masterHosts, updatedConfig.isPresent() ? this.toolbox.getObjectMapper().writeValueAsString(updatedConfig.get()) : this.configurationData, this.getClusterId(), this.auditAuthor, this.auditComment);
        }
        catch (IllegalStateException e) {
            log.info("ISE from setOverlordDynamicConfiguration(), master servers may be temporarily down: %s", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 20;
    }

    public String getDescription() {
        return "Modifying overlord dynamic configuration";
    }

    @JsonProperty
    @Generated
    public String getConfigurationData() {
        return this.configurationData;
    }

    @JsonProperty
    @Generated
    public String getAuditAuthor() {
        return this.auditAuthor;
    }

    @JsonProperty
    @Generated
    public String getAuditComment() {
        return this.auditComment;
    }

    @JsonProperty
    @Generated
    public boolean isMerge() {
        return this.merge;
    }
}

