/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Set;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ModifyLoadRuleConfigurationStage
extends MasterHostsStage {
    @Generated
    private static final Logger log = Logger.from(ModifyLoadRuleConfigurationStage.class);
    private final Set<String> masterHosts;
    private final String loadRule;
    private final String ruleConfiguration;
    private final String auditAuthor;
    private final String auditComment;

    @JsonCreator
    public ModifyLoadRuleConfigurationStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="masterHosts") Set<String> masterHosts, @JsonProperty(value="loadRule") String loadRule, @JsonProperty(value="ruleConfiguration") String ruleConfiguration, @JsonProperty(value="auditAuthor") String auditAuthor, @JsonProperty(value="auditComment") String auditComment) {
        super(toolbox, clusterId, nodeType);
        this.masterHosts = masterHosts;
        this.loadRule = loadRule;
        this.ruleConfiguration = ruleConfiguration;
        this.auditAuthor = auditAuthor;
        this.auditComment = auditComment;
    }

    @Override
    public boolean innerRun() {
        log.info("Setting [%s] load rule's configuration to [%s]", new Object[]{this.loadRule, this.ruleConfiguration});
        try {
            this.toolbox.getDruidApiClient().setLoadRuleConfiguration(this.findMasterHosts(), this.loadRule, this.ruleConfiguration, this.getClusterId(), this.auditAuthor, this.auditComment);
        }
        catch (IllegalStateException e) {
            log.info("ISE from setLoadRuleConfiguration(), master servers may be temporarily down: %s", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @JsonProperty
    public String getLoadRule() {
        return this.loadRule;
    }

    @JsonProperty
    public String getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    @JsonProperty
    public String getAuditAuthor() {
        return this.auditAuthor;
    }

    @JsonProperty
    public String getAuditComment() {
        return this.auditComment;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 20;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Modifying [%s] load rule's configuration", this.loadRule);
    }
}

