/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Set;

public class ModifyCoordinatorDynamicConfigurationStage
extends MasterHostsStage {
    private static final Logger log = new Logger(ModifyCoordinatorDynamicConfigurationStage.class);
    private final Set<String> masterHosts;
    private final String configurationData;
    private final Boolean restoringOriginal;
    private final String auditAuthor;
    private final String auditComment;

    @JsonCreator
    public ModifyCoordinatorDynamicConfigurationStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="masterHosts") Set<String> masterHosts, @JsonProperty(value="configurationData") String configurationData, @JsonProperty(value="restoringOriginal") Boolean restoringOriginal, @JsonProperty(value="auditAuthor") String auditAuthor, @JsonProperty(value="auditComment") String auditComment) {
        super(toolbox, clusterId, nodeType);
        this.masterHosts = masterHosts;
        this.configurationData = configurationData;
        this.restoringOriginal = restoringOriginal;
        this.auditAuthor = auditAuthor;
        this.auditComment = auditComment;
    }

    @Override
    public boolean innerRun() {
        log.info("Setting coordinator dynamic configuration to [%s]", new Object[]{this.configurationData});
        try {
            this.toolbox.getDruidApiClient().setCoordinatorDynamicConfiguration(this.findMasterHosts(), this.configurationData, this.getClusterId(), this.auditAuthor, this.auditComment);
        }
        catch (IllegalStateException e) {
            log.info("ISE from setCoordinatorDynamicConfiguration(), master servers may be temporarily down: %s", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @JsonProperty
    public String getConfigurationData() {
        return this.configurationData;
    }

    @JsonProperty(value="restoringOriginal")
    public Boolean isRestoringOriginal() {
        return this.restoringOriginal;
    }

    @JsonProperty
    public String getAuditAuthor() {
        return this.auditAuthor;
    }

    @JsonProperty
    public String getAuditComment() {
        return this.auditComment;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 20;
    }

    @JsonProperty
    public String getDescription() {
        if (this.restoringOriginal != null && this.restoringOriginal.booleanValue()) {
            return "Restoring original coordinator dynamic configuration";
        }
        return "Modifying coordinator dynamic configuration";
    }
}

