/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public class ModifyAutoCompactionDynamicConfigurationWithDetectedMasterStage
extends BaseStage {
    @Generated
    private static final Logger log = Logger.from(ModifyAutoCompactionDynamicConfigurationWithDetectedMasterStage.class);
    private final String auditAuthor;
    private final String auditComment;
    private final Double compactionSlotRatio;
    private final Integer maxTaskSlots;
    private final Boolean useAutoScaleSlots;

    @JsonCreator
    public ModifyAutoCompactionDynamicConfigurationWithDetectedMasterStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="compactionSlotRatio") Double compactionSlotRatio, @JsonProperty(value="maxTaskSlots") Integer maxTaskSlots, @JsonProperty(value="useAutoScaleSlots") Boolean useAutoScaleSlots, @JsonProperty(value="auditAuthor") String auditAuthor, @JsonProperty(value="auditComment") String auditComment) {
        super(toolbox, clusterId, nodeType);
        this.compactionSlotRatio = compactionSlotRatio;
        this.maxTaskSlots = maxTaskSlots;
        this.useAutoScaleSlots = useAutoScaleSlots;
        this.auditAuthor = auditAuthor;
        this.auditComment = auditComment;
    }

    @Override
    public boolean innerRun() throws Exception {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        if (cluster.getImplyVersionFull().getComparableVersion().compareTo(new ComparableVersion("2022.02")) < 0) {
            log.debug("Skipping setting auto compaction configs, only supported for cluster versions after 2022.02");
            return true;
        }
        log.info("Setting compaction dynamic configuration to ratio=[%f],max=[%d],useAutoScaleSlots=[%s]", new Object[]{this.compactionSlotRatio, this.maxTaskSlots, this.useAutoScaleSlots});
        List masterHosts = this.toolbox.getClusterNodesHelper().getSortedMasterHosts(this.getClusterId());
        try {
            this.toolbox.getDruidApiClient().configureAutoCompactionTaskSlots((Collection)masterHosts, this.getClusterId(), this.compactionSlotRatio, this.maxTaskSlots, this.useAutoScaleSlots, this.auditAuthor, this.auditComment);
        }
        catch (IllegalStateException e) {
            log.info("ISE from configureAutoCompactionTaskSlots(), master servers may be temporarily down: %s", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    public String getDescription() {
        return "Modifying auto compaction dynamic configuration";
    }

    @JsonProperty
    @Generated
    public String getAuditAuthor() {
        return this.auditAuthor;
    }

    @JsonProperty
    @Generated
    public String getAuditComment() {
        return this.auditComment;
    }

    @JsonProperty
    @Generated
    public Double getCompactionSlotRatio() {
        return this.compactionSlotRatio;
    }

    @JsonProperty
    @Generated
    public Integer getMaxTaskSlots() {
        return this.maxTaskSlots;
    }

    @JsonProperty
    @Generated
    public Boolean getUseAutoScaleSlots() {
        return this.useAutoScaleSlots;
    }
}

