/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;

public class EnableMiddleManagerStage
extends BaseStage {
    private static final Logger log = new Logger(EnableMiddleManagerStage.class);
    private final String host;

    @JsonCreator
    public EnableMiddleManagerStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="host") String host) {
        super(toolbox, clusterId);
        this.host = host;
    }

    @Override
    public boolean innerRun() {
        log.info("Enabling middle manager [%s]", new Object[]{this.host});
        try {
            Retryable.of(() -> this.toolbox.getDruidApiClient().enableMiddleManager(this.host, this.getClusterId()), (int)3, (int)1);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to enable middle manager [%s] in cluster [%s]", new Object[]{this.host, this.getClusterId()});
        }
        return true;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 5;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Enabling middle manager [%s]", this.host);
    }
}

