/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.MasterHostsStage;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.Logger;
import java.util.Set;

public class DisableMiddleManagerStage
extends MasterHostsStage {
    private static final Logger log = new Logger(DisableMiddleManagerStage.class);
    private final String host;
    private final Set<String> masterHosts;

    @JsonCreator
    public DisableMiddleManagerStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="nodeType") ImplyNodeType nodeType, @JsonProperty(value="host") String host, @JsonProperty(value="masterHosts") Set<String> masterHosts) {
        super(toolbox, clusterId, nodeType);
        this.host = host;
        this.masterHosts = masterHosts;
    }

    @Override
    public boolean innerRun() {
        log.info("Disabling middle manager [%s]", new Object[]{this.host});
        try {
            this.toolbox.getDruidApiClient().disableMiddleManager(this.host, this.getClusterId());
            return true;
        }
        catch (Exception e) {
            log.info((Throwable)e, "Bad response from middle manager [%s], checking if node is still registered with overlord", new Object[]{this.host});
            if (!this.toolbox.getDruidApiClient().isWorkerOnline(this.host, this.findMasterHosts(), this.getClusterId())) {
                log.info("Overlord no longer reports [%s] as available, continuing assuming middle manager is down", new Object[]{this.host});
                return true;
            }
            throw e;
        }
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty
    public Set<String> getMasterHosts() {
        return this.masterHosts;
    }

    @Override
    public Integer getCompletionTimeoutInMinutes() {
        return 10;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Disabling middle manager [%s] from receiving new task assignments", this.host);
    }
}

