/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.operations;

import com.google.inject.Singleton;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceHealth;
import io.imply.cloud.model.State;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.List;
import javax.inject.Inject;

@Singleton
public class HandleFailingInstancesNotice
extends OperationsNotice {
    private static final Logger log = new Logger(HandleFailingInstancesNotice.class);

    @Inject
    public HandleFailingInstancesNotice(ManagerToolbox toolbox) {
        super(toolbox);
    }

    @Override
    public void innerHandle() {
        List failedInstances = this.toolbox.getInstanceHealthDataManager().getAllFailedInstances();
        if (failedInstances != null) {
            for (InstanceHealth instanceHealth : failedInstances) {
                try {
                    Cluster cluster = this.toolbox.getClusterDataManager().get(instanceHealth.getClusterId());
                    Account account = this.toolbox.getAccountDataManager().get(cluster.getAccountId());
                    Info info = this.toolbox.getEntityStateDataManager().get(cluster);
                    ThreadLocalContext.setSystemContext((String)"isMock", (Object)info.isMockEntity());
                    log.warn("ACC [%s (%s)] CLU [%s] INS [%s] IP [%s] has failed [%s] health checks: %s", new Object[]{account.getAccountId(), account.getName(), cluster.getClusterId(), instanceHealth.getInstanceId(), instanceHealth.getHost(), instanceHealth.getConsecutiveFailureCount(), instanceHealth.getLastMessage()});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception while handling [%s] for failing health check", new Object[]{instanceHealth});
                }
                this.toolbox.getInstanceHealthDataManager().insert(InstanceHealth.builder().withInstanceHealth(instanceHealth).withFailureCount(Integer.valueOf(0)).build());
            }
        }
    }

    @Override
    protected State getTimeoutState() {
        throw new ISE("getTimeoutState() should not be getting called for HandleFailingInstancesNotice", new Object[0]);
    }
}

