/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.telemetry.CloudEvent;
import io.imply.cloud.util.Logger;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public abstract class PostUpdateNotice
extends Notice {
    private static final Logger log = new Logger(PostUpdateNotice.class);

    public PostUpdateNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    protected void innerHandle() {
        if (State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)this.info.getDesiredState())) {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_UPDATE_ROLLED_BACK).withProposedClusterVersion(Constants.CLEAR_FIELD_INT).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateType(UpdateType.NOT_SET).withNotificationCutoff(DateTime.now()).clearExistingUpdateState().build());
            log.info(true, "Cluster [%s] rolled back", new Object[]{this.info.getEntityId()});
            this.addInfoNotification("Cluster roll back completed", new Object[0]);
        } else {
            Info.Builder infoBuilder = Info.builder().withState(State.CLUSTER_UPDATED).withProposedClusterVersion(Constants.CLEAR_FIELD_INT).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateType(UpdateType.NOT_SET).withNotificationCutoff(DateTime.now()).clearExistingUpdateState();
            if (this.info.getProposedClusterVersion() != null) {
                infoBuilder.withDeployedClusterVersion(this.info.getProposedClusterVersion());
                infoBuilder.withConfigServerClusterVersion(this.info.getProposedClusterVersion());
            }
            if (this.info.getProposedClusterNodesVersion() != null) {
                infoBuilder.withDeployedClusterNodesVersion(this.info.getProposedClusterNodesVersion());
            }
            this.entityStateDataManager.insert(this.info, infoBuilder.build());
            String action = "updated";
            if (ListUtils.emptyIfNull((List)this.info.getTransitionStateChain()).contains(State.CLUSTER_RESTART_REQUEST_RECEIVED)) {
                action = "restarted";
            }
            log.info(true, "Cluster [%s] %s", new Object[]{this.info.getEntityId(), action});
            this.addInfoNotification("Cluster %s", action);
        }
        this.markNotificationsAsPrevious();
        this.toolbox.getClusterStackHelper().refreshClusterDetails(this.info.getEntityId());
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        this.toolbox.getEmitter().emit(this.getEvent(CloudEvent.metricBuilder((String)"project.update.duration", (Number)new Duration((ReadableInstant)cluster.getLastModified(), (ReadableInstant)DateTime.now()).getStandardSeconds(), (Cluster)cluster), cluster));
    }

    @Override
    protected State getTimeoutState() {
        return State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)this.info.getDesiredState()) ? State.CLUSTER_UPDATE_ROLLED_BACK : State.CLUSTER_UPDATED;
    }

    @Override
    protected Status getFailureStatus() {
        return Status.WARNING;
    }

    protected Event getEvent(MetricEvent.Builder eventBuilder, Cluster cluster) {
        Cluster originCluster = this.toolbox.getClusterDataManager().getVersionOrNull(this.info.getEntityId(), cluster.getVersion() - 1);
        return eventBuilder.addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"imply_version_prev", (Object)originCluster.getImplyVersion()).addAttribute((Object)"is_rollback", (Object)State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)this.info.getDesiredState())).addAttribute((Object)"platform", (Object)((Platform)ObjectUtils.defaultIfNull((Object)this.toolbox.getApplicationConfig().getPlatform(), (Object)Platform.ONPREM)).toString()).build();
    }
}

