/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.Logger;
import org.joda.time.DateTime;

public abstract class PostStartNotice
extends Notice {
    private static final Logger log = new Logger(PostStartNotice.class);

    public PostStartNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    protected void innerHandle() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STARTED).withDeployedClusterVersion(cluster.getVersion()).withNotificationCutoff(DateTime.now()).build());
        log.info(true, "Cluster [%s] started", new Object[]{this.info.getEntityId()});
        this.addInfoNotification("Cluster started", new Object[0]);
        this.markNotificationsAsPrevious();
        this.toolbox.getClusterStackHelper().refreshClusterDetails(this.info.getEntityId());
    }

    @Override
    protected State getTimeoutState() {
        return State.CLUSTER_STARTED;
    }
}

