/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.telemetry.CloudEvent;
import io.imply.cloud.util.Logger;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public abstract class PostCreateNotice
extends Notice {
    private static final Logger log = new Logger(PostCreateNotice.class);

    public PostCreateNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    protected void innerHandle() {
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_CREATED).withDeployedClusterVersion(this.info.getProposedClusterVersion()).withConfigServerClusterVersion(this.info.getProposedClusterVersion()).withDeployedClusterNodesVersion(this.info.getProposedClusterNodesVersion()).withProposedClusterVersion(Constants.CLEAR_FIELD_INT).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withNotificationCutoff(DateTime.now()).build());
        log.info(true, "Cluster [%s] created", new Object[]{this.info.getEntityId()});
        this.addInfoNotification("Cluster successfully created", new Object[0]);
        this.markNotificationsAsPrevious();
        this.toolbox.getClusterStackHelper().refreshClusterDetails(this.info.getEntityId());
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        this.toolbox.getEmitter().emit(this.getEvent(CloudEvent.metricBuilder((String)"project.create.duration", (Number)new Duration((ReadableInstant)cluster.getLastModified(), (ReadableInstant)DateTime.now()).getStandardSeconds(), (Cluster)cluster)));
    }

    @Override
    protected State getTimeoutState() {
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }

    protected Event getEvent(MetricEvent.Builder eventBuilder) {
        return eventBuilder.addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"platform", (Object)((Platform)ObjectUtils.defaultIfNull((Object)this.toolbox.getApplicationConfig().getPlatform(), (Object)Platform.ONPREM)).toString()).build();
    }
}

