/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice.cluster;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.ExceptionHandlingNotice;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.manager.util.StageGenerator;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.telemetry.CloudEvent;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public abstract class ExecuteStagedOperationNotice
extends ExceptionHandlingNotice {
    private static final Logger log = new Logger(ExecuteStagedOperationNotice.class);

    private Operation getOperation() {
        if (this.info.getDesiredState() == null) {
            return Operation.UNKNOWN;
        }
        switch (this.info.getDesiredState()) {
            case CLUSTER_CREATED: {
                return Operation.CREATE;
            }
            case CLUSTER_DELETED: {
                return Operation.TERMINATE;
            }
            case CLUSTER_STOPPED: {
                return Operation.STOP;
            }
            case CLUSTER_STARTED: {
                return Operation.START;
            }
            case CLUSTER_UPDATED: {
                return this.info.getState().equals((Object)State.KUBERNETES_STATEFULSET_ROLLING_UPDATE) ? Operation.STATEFULSET_UPDATE : Operation.UPDATE;
            }
            case CLUSTER_AGENT_UPDATED: {
                return Operation.AGENT_UPDATE;
            }
            case RDS_UPDATED: {
                return Operation.RDS_UPDATE;
            }
            case CLUSTER_UPDATE_ROLLED_BACK: {
                return Operation.ROLLBACK;
            }
        }
        return Operation.UNKNOWN;
    }

    public ExecuteStagedOperationNotice(ManagerToolbox toolbox) {
        super(toolbox, EntityType.CLUSTER);
    }

    @Override
    public void innerHandle() {
        Operation operation = this.getOperation();
        if (Operation.UNKNOWN.equals((Object)operation)) {
            throw new ISE("Unknown operation while attempting to execute staged transition, desiredState [%s]", new Object[]{this.info.getDesiredState()});
        }
        UpdateState transitionState = this.info.getUpdateState();
        if (transitionState == null) {
            throw new ISE("No transition state found for cluster [%s]", new Object[]{this.info.getEntityId()});
        }
        ArrayDeque<Stage> pendingStages = transitionState.getPendingRollingStages();
        if (pendingStages.isEmpty()) {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(operation.getSuccessState()).clearExistingUpdateState().build());
            this.addInfoNotification("All stages completed", new Object[0]);
            this.setQueueNextNotice();
            return;
        }
        Stage currentStage = (Stage)pendingStages.getFirst();
        if (currentStage == null) {
            this.addWarningNotification("Failed to deserialize stage, aborting operation", new Object[0]);
            this.entityStateDataManager.insert(this.info, Info.builder().withState(operation.getFailureState()).build());
            this.setQueueNextNotice();
            return;
        }
        if (transitionState.getRollingStageStartTime() == null) {
            transitionState = UpdateState.builder((UpdateState)transitionState).rollingStageStartTime(DateTime.now()).build();
            this.entityStateDataManager.insert(this.info, Info.builder().withUpdateState(transitionState).build());
        }
        int executionCount = transitionState.getRollingStageExecutionCount() == null ? 1 : transitionState.getRollingStageExecutionCount() + 1;
        MetricEvent.Builder metricEventBuilder = CloudEvent.metricBuilder((String)Event.name((String)currentStage.getName(), (String[])new String[]{"duration"}), (Cluster)this.toolbox.getClusterDataManager().get(this.info.getEntityId()));
        long startTimeNanoSeconds = System.nanoTime();
        try {
            this.addInfoNotification("[%s %d/%d] %s", operation.getDisplayName(), transitionState.getCurrentStageNumber(), transitionState.getTotalStageCount(), currentStage.getDescription());
            if (transitionState.getRollingStageStartTime().plusSeconds(currentStage.getExecutionDelayInSeconds().intValue()).isAfterNow()) {
                log.info("Waiting [%d] seconds before executing stage [%s]", new Object[]{currentStage.getExecutionDelayInSeconds(), currentStage.getName()});
                return;
            }
            currentStage.setExecutionCount(Integer.valueOf(executionCount));
            boolean stageComplete = currentStage.run(new Stage.State(transitionState.getRollingStageStartTime()));
            if (stageComplete) {
                Deque<Stage> completedStages;
                Deque deque = completedStages = transitionState.getCompletedRollingStages() == null ? new ArrayDeque() : transitionState.getCompletedRollingStages();
                if (currentStage instanceof BaseStage) {
                    ((BaseStage)currentStage).setCompletionTime(DateTime.now());
                }
                completedStages.add(currentStage);
                pendingStages.removeFirst();
                if (currentStage instanceof StageGenerator) {
                    List<Stage> generatedStages = ((StageGenerator)currentStage).generateStages();
                    ArrayDeque<Stage> stages = new ArrayDeque<Stage>(generatedStages);
                    stages.addAll((Collection<Stage>)pendingStages);
                    pendingStages = stages;
                    this.toolbox.getStageHelper().tagWithStageNumbers(stages, completedStages.size() + 1);
                    log.info("[%s] generated the stages: %s", new Object[]{currentStage.getName(), generatedStages.stream().map(Stage::getName).collect(Collectors.toList())});
                }
                this.entityStateDataManager.insert(this.info, Info.builder().withUpdateState(UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages((Deque)pendingStages).completedRollingStages(completedStages).clearTimerAndCounters().build()).build());
                this.setQueueNextNotice();
                return;
            }
            this.entityStateDataManager.insert(this.info, Info.builder().withUpdateState(UpdateState.builder((UpdateState)transitionState).rollingStageConsecutiveExceptions(Integer.valueOf(0)).rollingStageExecutionCount(Integer.valueOf(executionCount)).build()).build());
            if (transitionState.getRollingStageStartTime().plusMinutes(currentStage.getCompletionTimeoutInMinutes().intValue()).isBeforeNow()) {
                this.addWarningNotification("%s stage [%s] has exceeded its timeout period, aborting", operation.getDisplayName(), currentStage.getName());
                metricEventBuilder.addAttribute((Object)"result", (Object)"timeout");
                this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getTimeoutState()).build());
                this.setQueueNextNotice();
            }
        }
        catch (Stage.FailedException fe) {
            log.warn("Stage [%s] failed exceptionally", new Object[]{currentStage.getName()});
            metricEventBuilder.addAttribute((Object)"result", (Object)"failed");
            throw new RuntimeException(fe);
        }
        catch (Exception e) {
            int consecutiveExceptions;
            int n = consecutiveExceptions = transitionState.getRollingStageConsecutiveExceptions() == null ? 1 : transitionState.getRollingStageConsecutiveExceptions() + 1;
            if (consecutiveExceptions < currentStage.getMaxConsecutiveExceptions()) {
                log.warn((Throwable)e, "[%s] threw an exception, retrying on next run (%d/%d)", new Object[]{currentStage.getName(), consecutiveExceptions, currentStage.getMaxConsecutiveExceptions()});
                this.entityStateDataManager.insert(this.info, Info.builder().withUpdateState(UpdateState.builder((UpdateState)transitionState).rollingStageConsecutiveExceptions(Integer.valueOf(consecutiveExceptions)).rollingStageExecutionCount(Integer.valueOf(executionCount)).build()).build());
                return;
            }
            log.warn("Retries exhausted for [%s]", new Object[]{currentStage.getName()});
            metricEventBuilder.addAttribute((Object)"result", (Object)"failed");
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.toolbox.getEmitter().emit((Event)metricEventBuilder.addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"state", (Object)this.info.getState()).addAttribute((Object)"desired_state", (Object)this.info.getDesiredState()).value((Number)new Duration((ReadableInstant)transitionState.getRollingStageStartTime(), (ReadableInstant)DateTime.now()).getStandardSeconds()).build());
            this.emitStageRuntimeMetric(System.nanoTime() - startTimeNanoSeconds, currentStage);
        }
    }

    protected void emitStageRuntimeMetric(long durationNanoSeconds, Stage currentStage) {
        MetricEvent.Builder builder = MetricEvent.builder((String)MetricRegistry.name(this.getClass(), (String[])new String[]{"runtime_duration"})).addAttribute((Object)"platform", (Object)this.toolbox.getApplicationConfig().getPlatform()).addAttribute((Object)"stage", (Object)currentStage.getClass().getName()).value((Number)durationNanoSeconds);
        if (this.info != null) {
            builder.addAttribute((Object)"entity_id", (Object)this.info.getEntityId()).addAttribute((Object)"request_id", (Object)this.info.getRequestId()).addAttribute((Object)"entity_type", (Object)this.info.getEntityType());
        }
        this.toolbox.getEmitter().emit(this.buildDurationEvent(builder));
    }

    @Override
    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    @Override
    protected State getExceptionState() {
        return this.getOperation().getFailureState();
    }

    @Override
    protected Status getFailureStatus() {
        return this.getOperation().getFailureStatus();
    }

    private static enum Operation {
        CREATE(State.CLUSTER_STAGED_CREATION_COMPLETE, State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION, "Create"),
        START(State.CLUSTER_STAGED_CREATION_COMPLETE, State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION, "Start"),
        STOP(null, null, "Stop"),
        TERMINATE(null, null, "Terminate"),
        UPDATE(State.CLUSTER_ROLLING_UPDATE_COMPLETE, State.CLUSTER_UPDATE_FAILED_PROMPT_USER, "Update", Status.WARNING),
        AGENT_UPDATE(State.CLUSTER_AGENT_UPDATED, State.CLUSTER_AGENT_UPDATE_FAILED, "Update", Status.WARNING),
        STATEFULSET_UPDATE(State.UPDATING_CLUSTER_STACK, State.CLUSTER_UPDATE_FAILED_PROMPT_USER, "Update", Status.CRITICAL),
        ROLLBACK(State.CLUSTER_ROLLING_UPDATE_COMPLETE, State.CLUSTER_UPDATE_FAILED_PROMPT_USER, "Rollback"),
        RDS_UPDATE(State.RDS_UPDATED, State.RDS_UPDATE_ROLLBACK, "Update", Status.WARNING),
        UNKNOWN(null, null, "Unknown");

        private final State successState;
        private final State failureState;
        private final String displayName;
        private final Status failureStatus;

        private Operation(State successState, State failureState, String displayName) {
            this(successState, failureState, displayName, Status.CRITICAL);
        }

        private Operation(State successState, State failureState, String displayName, Status failureStatus) {
            this.successState = successState;
            this.failureState = failureState;
            this.displayName = displayName;
            this.failureStatus = failureStatus;
        }

        private State getSuccessState() {
            return this.successState;
        }

        private State getFailureState() {
            return this.failureState;
        }

        private String getDisplayName() {
            return this.displayName;
        }

        private Status getFailureStatus() {
            return this.failureStatus;
        }
    }
}

