/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.notice;

import com.amazonaws.AmazonServiceException;
import io.imply.cloud.exception.StagedOperationException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;

public abstract class ExceptionHandlingNotice
extends Notice {
    private static final Logger log = new Logger(ExceptionHandlingNotice.class);

    public ExceptionHandlingNotice(ManagerToolbox toolbox, EntityType expectedEntityType) {
        super(toolbox, expectedEntityType);
    }

    @Override
    public final void handle() {
        this.validate();
        try {
            super.handle(true);
        }
        catch (Exception e) {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
            if (e instanceof AmazonServiceException) {
                this.addFailureNotification(Notification.Source.AWS, ExceptionHandlingNotice.formatAmazonServiceExceptionMessage((AmazonServiceException)e), new Object[0]);
            } else if (e instanceof StagedOperationException) {
                this.addFailureNotification("%s (ref: %s)", e.getMessage(), this.getRequestId());
            } else {
                log.error((Throwable)e, "Unhandled exception, ref: %s", new Object[]{this.getRequestId()});
                this.addFailureNotification("%s%s (ref: %s)", this.toolbox.isOnPrem() ? "Unexpected error" : "Unable to complete operation, please contact support", e.getMessage() == null ? "" : String.format(" [%s]", e.getMessage()), this.getRequestId());
            }
        }
        finally {
            ThreadLocalContext.clear();
        }
    }

    protected abstract State getExceptionState();

    protected void postNotificationAndSetFailureState(String message, Object ... formatArgs) {
        log.warn(message, formatArgs);
        this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
        if (Status.WARNING.equals((Object)this.getFailureStatus())) {
            this.addWarningNotification(Notification.Source.MANAGER, message, formatArgs);
        } else {
            this.addCriticalNotification(Notification.Source.MANAGER, message, formatArgs);
        }
    }

    private static String formatAmazonServiceExceptionMessage(AmazonServiceException e) {
        if (e == null) {
            return "";
        }
        if (e.getErrorCode() != null && e.getErrorMessage() != null) {
            return String.format("%s: %s", e.getErrorCode(), e.getErrorMessage());
        }
        if (e.getErrorMessage() != null) {
            return e.getErrorMessage();
        }
        if (e.getErrorCode() != null) {
            return e.getErrorCode();
        }
        return e.getClass().getSimpleName();
    }
}

