/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.user;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DeleteUserAction
extends AuthenticatedAction {
    private final String userId;
    private User user;

    @JsonCreator
    public DeleteUserAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="userId") String userId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
        this.userId = userId;
    }

    @Override
    public Object innerPerform() {
        if (this.userId.equals(this.getPrincipalId())) {
            throw new IAE("Failed to delete user: unable to delete self", new Object[0]);
        }
        String deletedUserId = this.getToolbox().getUserDataManager().delete(this.userId, ThreadLocalContext.getPrincipal().getDetailedUserId());
        return ImmutableMap.of((Object)"userId", (Object)deletedUserId);
    }

    @Override
    public boolean isAuthorized(User principal) {
        return principal.getAccountIds().containsAll(this.getUser().getAccountIds());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", (Object)this.userId).append("context", this.getContext()).toString();
    }

    @Override
    public Collection<String> getAccountIds() {
        return this.getUser().getAccountIds();
    }

    private User getUser() {
        if (this.user == null) {
            Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"[userId] required");
            this.user = this.getToolbox().getUserDataManager().get(this.userId);
        }
        return this.user;
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS, (Object)Platform.ONPREM);
    }
}

