/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ValidateClusterAction
extends AccountAuthenticatedAction {
    private final Cluster cluster;

    @JsonCreator
    public ValidateClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="cluster") Cluster cluster, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, cluster != null ? cluster.getAccountId() : null);
        this.cluster = cluster;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        return Collections.singletonMap("results", this.validate());
    }

    private List<ImplyConstraintViolation> validate() {
        if (this.cluster.getAccountId() == null) {
            return Collections.singletonList(ImplyConstraintViolation.error((String)"accountId", (String)"[accountId] is a required field", (Object[])new Object[0]));
        }
        Account account = this.getToolbox().getAccountDataManager().getOrNull(this.cluster.getAccountId());
        if (account == null) {
            return Collections.singletonList(ImplyConstraintViolation.error((String)"accountId", (String)"accountId [%s] does not exist", (Object[])new Object[]{this.cluster.getAccountId()}));
        }
        ThreadLocalContext.setSystemContext((String)"skipGroveValidation", (Object)true);
        ImplyVersion implyVersionFull = this.cluster.getImplyVersionFull() != null ? this.cluster.getImplyVersionFull() : this.getToolbox().getImplyVersionHelper().lookupImplyVersionIncludingAccountVersions(this.cluster.getImplyVersion(), this.cluster.getAccountId(), this.getToolbox().getClusterDataManager());
        Cluster clusterToValidate = this.cluster.cloner().withDefaultsForUnset(this.toolbox.getApplicationConfig(), true, this.toolbox.getInstanceTypeHelper()).withImplyVersionFull(implyVersionFull).build();
        return clusterToValidate.validate(account, (Toolbox)this.getToolbox(), true, false);
    }

    @Override
    public boolean isAuthorized(User principal) {
        return true;
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cluster", (Object)this.cluster).append("context", this.getContext()).toString();
    }
}

