/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.Constants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateClusterNodesAction
extends ClusterAuthenticatedAction {
    private static final Logger log = new Logger(UpdateClusterNodesAction.class);
    private final UpdateType updateType;
    private final ClusterNodes clusterNodes;

    @JsonCreator
    public UpdateClusterNodesAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="updateType") UpdateType updateType, @JsonProperty(value="clusterNodes") ClusterNodes clusterNodes, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterNodes == null ? null : clusterNodes.getClusterId());
        this.updateType = updateType;
        this.clusterNodes = clusterNodes;
    }

    @Override
    public Object innerPerform() {
        HashMap<String, NodeConfiguration> mergedNodes;
        Preconditions.checkArgument((this.updateType != null ? 1 : 0) != 0, (Object)"[updateType] required and must be one of: [ROLLING, HARD]");
        Preconditions.checkArgument((this.clusterNodes != null ? 1 : 0) != 0, (Object)"[clusterNodes] required");
        Preconditions.checkArgument((this.clusterNodes.getClusterId() != null ? 1 : 0) != 0, (Object)"[clusterNodes.clusterId] required");
        Preconditions.checkArgument((this.clusterNodes.getVersion() != null ? 1 : 0) != 0, (Object)"[clusterNodes.version] required");
        ClusterNodes originalClusterNodes = this.getToolbox().getClusterNodesDataManager().getOrNull(this.clusterNodes.getClusterId());
        ClusterNodes clusterNodesToUpdate = this.clusterNodes.cloner().withoutNonUpdatableFields().build();
        clusterNodesToUpdate.validate((Toolbox)this.getToolbox(), true);
        HashMap<String, Object> hashMap = mergedNodes = this.clusterNodes.getNodes() == null ? new HashMap<String, NodeConfiguration>() : new HashMap(this.clusterNodes.getNodes());
        if (originalClusterNodes.getNodes() != null) {
            for (Map.Entry entry : originalClusterNodes.getNodes().entrySet()) {
                if (entry.getValue() == null || ((NodeConfiguration)entry.getValue()).isCattle() == null || !((NodeConfiguration)entry.getValue()).isCattle().booleanValue()) continue;
                mergedNodes.put((String)entry.getKey(), (NodeConfiguration)entry.getValue());
            }
        }
        clusterNodesToUpdate = clusterNodesToUpdate.cloner().withNodes(mergedNodes).build();
        clusterNodesToUpdate.validate((Toolbox)this.getToolbox(), true);
        ClusterNodes diffClusterNodes = clusterNodesToUpdate.mergeDiff(originalClusterNodes);
        if (diffClusterNodes.isEmpty()) {
            throw new IAE("Unable to apply clusterNodes update for cluster [%s] - nothing has changed", new Object[]{this.clusterNodes.getClusterId()});
        }
        List<UpdateDetails> possibleUpdateTypes = this.getToolbox().getClusterUpdateHelper().getUpdateDetailsForClusterNodesDiff(diffClusterNodes, originalClusterNodes);
        if (possibleUpdateTypes.stream().anyMatch(x -> UpdateType.UNSUPPORTED.equals((Object)x.getType()))) {
            List displayText = possibleUpdateTypes.stream().filter(x -> UpdateType.UNSUPPORTED.equals((Object)x.getType())).findFirst().get().getDisplayText();
            throw new IAE("Changeset contains unsupported update parameters: %s", new Object[]{displayText});
        }
        Cluster cluster = this.getToolbox().getClusterDataManager().get(clusterNodesToUpdate.getClusterId());
        Info info = this.getToolbox().getEntityStateDataManager().get(cluster);
        boolean onlyUpdateSpec = info.getState().isStoppedTerminatedOrFailed();
        if (onlyUpdateSpec) {
            log.info("Only updating list of nodes for cluster [%s]", new Object[]{clusterNodesToUpdate.getClusterId()});
            ClusterNodes retVal = this.getToolbox().getClusterNodesDataManager().insertWithInfo(clusterNodesToUpdate, this.getDefaultInfoBuilder(cluster).build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), false, true, true);
            return retVal;
        }
        if (!State.CLUSTER_UPDATE_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{clusterNodesToUpdate.getClusterId(), info.getState(), State.CLUSTER_UPDATE_REQUEST_RECEIVED, State.CLUSTER_UPDATE_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        if (possibleUpdateTypes.stream().noneMatch(x -> x.getType().equals((Object)this.updateType))) {
            throw new IAE("updateType [%s] is not valid for this changeset, possible types: %s", new Object[]{this.updateType, possibleUpdateTypes.stream().map(UpdateDetails::getType).collect(Collectors.toList())});
        }
        ClusterNodes modifiedParameters = diffClusterNodes.cloner().withoutNonUpdatableFields().withVersion(null).build();
        ClusterNodes originalParameters = originalClusterNodes.filterNonNullFields(modifiedParameters);
        ImmutableList supportedTypes = UpdateType.HARD.equals((Object)this.updateType) ? ImmutableList.of((Object)UpdateType.HARD) : possibleUpdateTypes.stream().map(UpdateDetails::getType).collect(Collectors.toList());
        Info.Builder updateInfoBuilder = this.getDefaultInfoBuilder(cluster).withState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(this.updateType).withProposedClusterVersion(Constants.CLEAR_FIELD_INT).withProposedClusterNodesVersion(clusterNodesToUpdate.getVersion()).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).modifiedParameters((Map)this.getToolbox().getObjectMapper().convertValue((Object)modifiedParameters, (TypeReference)new TypeReference<Map<String, Object>>(){})).originalParameters((Map)this.getToolbox().getObjectMapper().convertValue((Object)originalParameters, (TypeReference)new TypeReference<Map<String, Object>>(){})).supportedTypes((List)supportedTypes).build()).clearExistingUpdateState();
        ClusterNodes retVal = this.getToolbox().getClusterNodesDataManager().insertWithInfo(clusterNodesToUpdate, updateInfoBuilder.build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), false, false, true);
        this.clearAllNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster update requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(this.getToolbox().getEntityStateDataManager().get(cluster));
        return retVal;
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.clusterNodes != null ? 1 : 0) != 0, (Object)"[clusterNodes] required");
        Preconditions.checkArgument((this.clusterNodes.getClusterId() != null ? 1 : 0) != 0, (Object)"[clusterNodes.clusterId] required");
        return super.isAuthorized(principal);
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.ONPREM);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("updateType", (Object)this.updateType).append("clusterNodes", (Object)this.clusterNodes).append("context", this.getContext()).toString();
    }
}

