/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class StartClusterAction
extends ClusterAuthenticatedAction {
    @JsonProperty
    private final String clusterId;

    @JsonCreator
    public StartClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        int proposedTotalMICU;
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        ClusterNodes clusterNodes = this.getToolbox().getClusterNodesDataManager().getOrNull(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().getOrNull(cluster);
        if (existingInfo != null && !State.CLUSTER_START_REQUEST_RECEIVED.getValidPreviousStates().contains(existingInfo.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{this.clusterId, existingInfo.getState(), State.CLUSTER_START_REQUEST_RECEIVED, State.CLUSTER_START_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        Account account = this.getToolbox().getAccountDataManager().get(cluster.getAccountId());
        if (account.isValueExceedingIcuLimit(proposedTotalMICU = this.getToolbox().getClusterUpdateHelper().getTotalMICU(account.getAccountId(), cluster))) {
            throw new IAE("Failed to start cluster: ICU limit of [%d] would be exceeded", new Object[]{account.getIcuLimit()});
        }
        cluster.validate(account, (Toolbox)this.getToolbox(), false);
        if (clusterNodes != null) {
            clusterNodes.validate((Toolbox)this.getToolbox(), true);
        }
        Info info = this.getToolbox().getEntityStateDataManager().insert(cluster, this.getDefaultInfoBuilder(cluster).withState(State.CLUSTER_START_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_STARTED).build());
        this.clearAllNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster start requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(info);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }
}

