/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.joda.time.DateTime;

public class SkipToClusterUpdateStageAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final Integer stageNumber;

    @JsonCreator
    public SkipToClusterUpdateStageAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="stageNumber") Integer stageNumber, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.stageNumber = stageNumber;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Preconditions.checkArgument((this.stageNumber != null ? 1 : 0) != 0, (Object)"[stageNumber] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().get(cluster);
        SkipToClusterUpdateStageAction.validateState(existingInfo);
        int currentStageNumber = ((Stage)existingInfo.getUpdateState().getPendingRollingStages().getFirst()).getStageNumber();
        if (this.stageNumber <= currentStageNumber) {
            throw new IAE("stageNumber [%d] must be higher than current stage [%d]", new Object[]{this.stageNumber, currentStageNumber});
        }
        this.getToolbox().getNoticeManager().queueNoticeAndAwaitCompletion(new SkipToClusterUpdateStageNotice(this.getToolbox(), existingInfo, this.stageNumber), true, 20000L);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("stageNumber", (Object)this.stageNumber).append("context", this.getContext()).toString();
    }

    private static void validateState(Info info) {
        if (!info.getState().isCreatingStartingOrUpdating()) {
            throw new IAE("Cluster [%s] is not in an updating state", new Object[]{info.getEntityId()});
        }
        if (info.getUpdateState() == null || info.getUpdateState().getPendingRollingStages() == null || info.getUpdateState().getPendingRollingStages().isEmpty()) {
            throw new IAE("Cluster [%s] is not executing update stages", new Object[]{info.getEntityId()});
        }
    }

    public static class SkipToClusterUpdateStageNotice
    extends OperationsNotice {
        private static final Logger log = new Logger(SkipToClusterUpdateStageNotice.class);
        private final int stageNumber;

        private SkipToClusterUpdateStageNotice(ManagerToolbox toolbox, Info info, int stageNumber) {
            super(toolbox, info);
            this.stageNumber = stageNumber;
        }

        @Override
        protected void innerHandle() {
            Stage stage;
            Deque<Stage> completedStages;
            SkipToClusterUpdateStageAction.validateState(this.info);
            int currentStageNumber = ((Stage)this.info.getUpdateState().getPendingRollingStages().getFirst()).getStageNumber();
            if (this.stageNumber <= currentStageNumber) {
                log.error("stageNumber [%d] must be higher than current stage [%d]", new Object[]{this.stageNumber, currentStageNumber});
                return;
            }
            Deque pendingStages = this.info.getUpdateState().getPendingRollingStages();
            Deque deque = completedStages = this.info.getUpdateState().getCompletedRollingStages() == null ? new ArrayDeque() : this.info.getUpdateState().getCompletedRollingStages();
            while ((stage = (Stage)pendingStages.peek()) != null && stage.getStageNumber() < this.stageNumber) {
                if (stage instanceof BaseStage) {
                    ((BaseStage)stage).setCompletionTime(DateTime.now());
                }
                completedStages.add(stage);
                pendingStages.removeFirst();
            }
            this.toolbox.getEntityStateDataManager().insert(this.info, Info.builder().withUpdateState(UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages(pendingStages).completedRollingStages(completedStages).clearTimerAndCounters().build()).build());
            this.addInfoNotification("Skipped to update stage [%d]", this.stageNumber);
        }
    }
}

