/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class RollbackClusterUpdateAction
extends ClusterAuthenticatedAction {
    private final UpdateType updateType;
    private final String clusterId;

    @JsonCreator
    public RollbackClusterUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="updateType") UpdateType updateType, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.updateType = updateType;
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().getOrNull(cluster);
        if (existingInfo == null) {
            throw new ISE("Can't retrieve state for cluster [%s]", new Object[]{this.clusterId});
        }
        if (!State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED.getValidPreviousStates().contains(existingInfo.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{this.clusterId, existingInfo.getState(), State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED, State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        if (State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)existingInfo.getDesiredState())) {
            throw new IAE("Can't initiate a rollback while already performing a rollback for cluster [%s]", new Object[]{this.clusterId});
        }
        Info.Builder infoBuilder = this.getDefaultInfoBuilder(cluster).withState(State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATE_ROLLED_BACK);
        if (this.updateType != null) {
            if (existingInfo.getUpdateState() == null || existingInfo.getUpdateState().getSupportedTypes() == null || existingInfo.getUpdateType() == null) {
                throw new ISE("Can't retrieve update state for cluster [%s]", new Object[]{this.clusterId});
            }
            if (!existingInfo.getUpdateState().getSupportedTypes().contains(this.updateType)) {
                throw new IAE("[%s] is not a supported updateType for the current update", new Object[]{this.updateType});
            }
            if (UpdateType.HARD.equals((Object)existingInfo.getUpdateType()) && UpdateType.ROLLING.equals((Object)this.updateType)) {
                throw new IAE("Can't transition from a HARD to a ROLLING updateType", new Object[0]);
            }
            infoBuilder.withUpdateType(this.updateType);
        }
        infoBuilder.withMaxSurgeCount(existingInfo.getMaxSurgeCount());
        Info info = this.getToolbox().getEntityStateDataManager().insert(cluster, infoBuilder.build());
        this.clearAllNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster rollback requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(info);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }
}

