/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.action.cluster.UpdateClusterAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import java.util.Objects;

public class RevertClusterAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final Integer version;
    private final String comments;
    private final UpdateType updateType;

    @JsonCreator
    public RevertClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="version") Integer version, @JsonProperty(value="comments") String comments, @JsonProperty(value="updateType") UpdateType updateType, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.version = version;
        this.comments = comments;
        this.updateType = updateType;
    }

    @Override
    protected Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Preconditions.checkArgument((this.version != null ? 1 : 0) != 0, (Object)"[version] required");
        Cluster deployedCluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Integer latestVersion = deployedCluster.getVersion();
        if (Objects.equals(latestVersion, this.version)) {
            throw new IAE("Failed to revert cluster, version [%s] is the latest", new Object[]{this.version});
        }
        Cluster revertToCluster = this.getToolbox().getClusterDataManager().getVersionOrNull(this.clusterId, this.version.intValue());
        if (revertToCluster == null) {
            throw new IAE("Failed to revert cluster, version [%s] not found", new Object[]{this.version});
        }
        String revertComment = this.comments == null ? "Revert to version " + this.version : "Revert to version " + this.version + " : " + this.comments;
        revertToCluster = revertToCluster.cloner().withComments(revertComment).build();
        UpdateClusterAction updateCluster = new UpdateClusterAction(this.getToolbox(), this.updateType, this.getContext(), this.getPrincipalId(), revertToCluster, true, 1);
        updateCluster.innerPerform();
        return ImmutableMap.of((Object)"clusterId", (Object)revertToCluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("version", (Object)this.version).append("comments", (Object)this.comments).append("updateType", (Object)this.updateType).append("context", this.getContext()).toString();
    }
}

