/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Constants;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.util.IAE;
import java.util.List;
import java.util.Map;

public class RdsUpdateAction
extends ClusterAuthenticatedAction {
    @JsonCreator
    public RdsUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
    }

    @Override
    public Object innerPerform() {
        Info info = this.getInfo();
        if (!State.PLAN_RDS_UPDATE.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{this.getClusterId(), info.getState(), State.PLAN_RDS_UPDATE, State.PLAN_RDS_UPDATE.getValidPreviousStates()});
        }
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.getClusterId());
        Info.Builder infoBuilder = this.getDefaultInfoBuilder(cluster).withState(State.PLAN_RDS_UPDATE).withDesiredState(State.RDS_UPDATED).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.PLAN_RDS_UPDATE).build()).clearExistingUpdateState();
        this.toolbox.getEntityStateDataManager().insert(cluster, infoBuilder.build());
        this.clearAllNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "RDS update requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(infoBuilder.build());
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.AWS);
    }
}

