/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.imply.cloud.manager.DescribeClusterHelper;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ThreadUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;

public class DescribeClustersAction
extends AccountAuthenticatedAction {
    private static final Logger log = new Logger(DescribeClustersAction.class);
    @JsonProperty
    private final String accountId;
    @JsonProperty
    private final boolean showNotifications;

    @JsonCreator
    public DescribeClustersAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="notifications") Boolean showNotifications, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
        this.showNotifications = BooleanUtils.isNotFalse((Boolean)showNotifications);
    }

    @Override
    public Object innerPerform() {
        List clusters;
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        if (!this.getToolbox().getAccountDataManager().exists(this.accountId)) {
            throw new IAE("Failed to describe clusters: account [%s] does not exist", new Object[]{this.accountId});
        }
        Class<?> noticeOrActionClass = this.getClass();
        User principal = ThreadLocalContext.getPrincipal();
        String requestId = ThreadLocalContext.getRequestId();
        String parentSpanId = ThreadLocalContext.getParentSpanId();
        String spanId = ThreadLocalContext.getSpanId();
        String cacheId = ThreadLocalContext.getCacheId();
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (Cluster cluster : this.getToolbox().getClusterDataManager().getAllWithAccountId(this.accountId, DeletedVisibility.SHOW_RECENT)) {
            futures.add(this.getToolbox().getWorkerExecutor().submit(() -> {
                HashMap<String, String> myContext = new HashMap<String, String>(this.getContext());
                String originalThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(ThreadUtils.getExtendedThreadName((String)originalThreadName, (String)(principal != null ? principal.getDetailedUserId() : null), (String)requestId));
                try {
                    this.handleMagicTags(cluster, myContext);
                    ThreadLocalContext.setNoticeOrActionClass((Class)noticeOrActionClass);
                    ThreadLocalContext.setPrincipal((User)principal);
                    ThreadLocalContext.setRequestId((String)requestId);
                    ThreadLocalContext.setParentSpanId((String)parentSpanId);
                    ThreadLocalContext.setSpanId((String)spanId);
                    ThreadLocalContext.setCacheId((String)cacheId);
                    ThreadLocalContext.setUserContext(myContext);
                    ClusterWithExtendedInfo clusterWithExtendedInfo = DescribeClusterHelper.describeCluster(this.getToolbox(), cluster.getClusterId(), this.showNotifications);
                    return clusterWithExtendedInfo;
                }
                catch (Throwable e) {
                    log.warn(e, "Exception while calling describe on clusterId [%s]", new Object[]{cluster.getClusterId()});
                    throw e;
                }
                finally {
                    Thread.currentThread().setName(originalThreadName);
                    ThreadLocalContext.clear();
                }
            }));
        }
        try {
            ListenableFuture f = Futures.successfulAsList(futures);
            if (f == null) {
                throw new ISE("Futures returned are null", new Object[0]);
            }
            clusters = (List)f.get(60L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return ImmutableMap.of((Object)"clusters", (Object)clusters);
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }
}

