/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.stage.AwaitAgentReplacementStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class DescribeClusterReplaceableAgentsAction
extends ClusterAuthenticatedAction {
    private final String clusterId;

    @JsonCreator
    public DescribeClusterReplaceableAgentsAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Info info = this.getToolbox().getEntityStateDataManager().get(cluster);
        if (State.PLAN_CLUSTER_AGENT_UPDATE.equals((Object)info.getState())) {
            return ImmutableList.of();
        }
        if (!State.CLUSTER_AGENT_UPDATE_IN_PROGRESS.equals((Object)info.getState())) {
            throw new IAE("Invalid state [%s]", new Object[]{info.getState()});
        }
        Deque pendingStages = info.getUpdateState().getPendingRollingStages();
        if (pendingStages.isEmpty() || !(pendingStages.getFirst() instanceof AwaitAgentReplacementStage)) {
            return ImmutableList.of();
        }
        AwaitAgentReplacementStage stage = (AwaitAgentReplacementStage)pendingStages.getFirst();
        if (stage.getReplacement() != null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)stage.getHost());
    }

    @Override
    protected List<Platform> getSupportedPlatforms() {
        return ImmutableList.of((Object)Platform.ONPREM);
    }
}

