/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ClusterNodesWithInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashMap;
import java.util.Map;

public class DescribeClusterNodesUpdateAction
extends ClusterAuthenticatedAction {
    private final ClusterNodes clusterNodes;

    @JsonCreator
    public DescribeClusterNodesUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterNodes") ClusterNodes clusterNodes, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterNodes != null ? clusterNodes.getClusterId() : null);
        this.clusterNodes = clusterNodes;
    }

    @Override
    public Object innerPerform() {
        HashMap<String, NodeConfiguration> mergedNodes;
        Preconditions.checkArgument((this.clusterNodes != null ? 1 : 0) != 0, (Object)"[clusterNodes] required");
        Preconditions.checkArgument((this.clusterNodes.getClusterId() != null ? 1 : 0) != 0, (Object)"[clusterNodes.clusterId] required");
        ClusterNodes originalClusterNodes = this.getToolbox().getClusterNodesDataManager().get(this.clusterNodes.getClusterId());
        ClusterNodes clusterNodesWithUpdatableFields = this.clusterNodes.cloner().withoutNonUpdatableFields().build();
        ClusterNodes mergedClusterNodes = originalClusterNodes.cloner().withClusterNodes(clusterNodesWithUpdatableFields, true).build();
        mergedClusterNodes.validate((Toolbox)this.getToolbox(), true);
        HashMap<String, Object> hashMap = mergedNodes = this.clusterNodes.getNodes() == null ? new HashMap<String, NodeConfiguration>() : new HashMap(this.clusterNodes.getNodes());
        if (originalClusterNodes.getNodes() != null) {
            for (Map.Entry entry : originalClusterNodes.getNodes().entrySet()) {
                if (entry.getValue() == null || ((NodeConfiguration)entry.getValue()).isCattle() == null || !((NodeConfiguration)entry.getValue()).isCattle().booleanValue()) continue;
                mergedNodes.put((String)entry.getKey(), (NodeConfiguration)entry.getValue());
            }
        }
        mergedClusterNodes = mergedClusterNodes.cloner().withNodes(mergedNodes).build();
        mergedClusterNodes.validate((Toolbox)this.getToolbox(), true);
        ClusterNodes diffClusterNodes = mergedClusterNodes.mergeDiff(originalClusterNodes);
        Info.Builder infoBuilder = this.getDefaultInfoBuilder();
        infoBuilder.withAvailableUpdateTypes(this.getToolbox().getClusterUpdateHelper().getUpdateDetailsForClusterNodesDiff(diffClusterNodes, originalClusterNodes));
        return ClusterNodesWithInfo.build((ClusterNodes)diffClusterNodes, (Info)infoBuilder.build(), (boolean)true);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.clusterNodes != null ? 1 : 0) != 0, (Object)"[clusterNodes] required");
        Preconditions.checkArgument((this.clusterNodes.getClusterId() != null ? 1 : 0) != 0, (Object)"[clusterNodes.clusterId] required");
        return super.isAuthorized(principal);
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterNodes", (Object)this.clusterNodes).append("context", this.getContext()).toString();
    }
}

