/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterDiff;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTime;

public class DescribeClusterDiffHistoryAction
extends ClusterAuthenticatedAction {
    private final String clusterId;

    @JsonCreator
    public DescribeClusterDiffHistoryAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    protected Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        List clusterList = this.getToolbox().getClusterDataManager().getAllVersions(this.clusterId, DeletedVisibility.SHOW_RECENT);
        if (clusterList == null || clusterList.isEmpty()) {
            return ImmutableList.of();
        }
        List diffList = IntStream.range(0, clusterList.size() - 1).mapToObj(clusterObj -> clusterList.subList(clusterObj, clusterList.size())).map(clusters -> this.createClusterDiffObject((Cluster)clusters.get(0), (Cluster)clusters.get(1))).collect(Collectors.toList());
        Cluster originalCluster = (Cluster)clusterList.get(clusterList.size() - 1);
        diffList.add(ClusterDiff.build((Integer)originalCluster.getVersion(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (String)originalCluster.getModifiedBy(), (DateTime)originalCluster.getCreated(), (String)originalCluster.getComments()));
        return ImmutableList.copyOf(diffList);
    }

    private ClusterDiff createClusterDiffObject(Cluster updatedCluster, Cluster originalCluster) {
        Cluster diffCluster = updatedCluster.mergeDiff(originalCluster);
        Cluster modifiedParameters = diffCluster.cloner().withoutNonUpdatableFields().withSensitiveFieldsMasked().withVersion(null).withComments(null).withImplyVersionFull(null).build();
        Cluster originalParameters = originalCluster.cloner().withSensitiveFieldsMasked().withComments(null).build().filterNonNullFields(modifiedParameters);
        DateTime updatedOn = updatedCluster.getLastModified();
        String updatedBy = updatedCluster.getModifiedBy();
        Integer version = updatedCluster.getVersion();
        return ClusterDiff.build((Integer)version, (Map)Cluster.clusterToMapWithoutType((ObjectMapper)this.getToolbox().getObjectMapper(), (Cluster)originalParameters), (Map)Cluster.clusterToMapWithoutType((ObjectMapper)this.getToolbox().getObjectMapper(), (Cluster)modifiedParameters), (String)updatedBy, (DateTime)updatedOn, (String)diffCluster.getComments());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }
}

