/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;

public class DeleteClusterAction
extends ClusterAuthenticatedAction {
    @JsonProperty
    private final String clusterId;

    @JsonCreator
    public DeleteClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        Preconditions.checkArgument((boolean)BooleanUtils.isNotTrue((Boolean)cluster.isDeletionProtection()), (Object)"[deletionProtection] is enabled");
        this.handleMagicTags(cluster, this.getContext());
        Info info = this.getToolbox().getNoticeManager().clearNoticesForEntityId(this.clusterId, () -> this.getToolbox().getEntityStateDataManager().insert(cluster, this.getDefaultInfoBuilder(cluster).withState(State.CLUSTER_DELETE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_DELETED).withNotificationCutoff(DateTime.now()).build()));
        this.clearAllNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster deletion requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(info);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("context", this.getContext()).toString();
    }
}

