/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Constants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.User;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.SecurityUtil;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class CreateClusterAction
extends AccountAuthenticatedAction {
    @JsonProperty
    private final Cluster cluster;
    @JsonProperty
    private final boolean skipValidation;

    @JsonCreator
    public CreateClusterAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="cluster") Cluster cluster, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        this(toolbox, cluster, false, context, principal);
    }

    public CreateClusterAction(ManagerToolbox toolbox, Cluster cluster, Boolean skipValidation, Map<String, String> context, String principal) {
        super(toolbox, context, principal, cluster != null ? cluster.getAccountId() : null);
        this.cluster = cluster;
        this.skipValidation = BooleanUtils.isTrue((Boolean)skipValidation);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Account account = this.getToolbox().getAccountDataManager().getOrNull(this.cluster.getAccountId());
        if (account == null) {
            throw new IAE("Failed to create cluster: account [%s] does not exist", new Object[]{this.cluster.getAccountId()});
        }
        ImplyVersion implyVersionFull = this.cluster.getImplyVersionFull() != null ? this.cluster.getImplyVersionFull() : this.getToolbox().getImplyVersionHelper().lookupImplyVersionIncludingAccountVersions(this.cluster.getImplyVersion(), this.cluster.getAccountId(), this.getToolbox().getClusterDataManager());
        Cluster clusterToCreate = this.cluster.cloner().withSensitiveFieldPlaceholdersReplaced(this.getToolbox().getDefaultsConfig()).withDefaultsForUnset(this.getToolbox().getApplicationConfig(), true, this.getToolbox().getInstanceTypeHelper()).withoutNonUpdatableFields().withImplyVersionFull(implyVersionFull).withImplyVersion(implyVersionFull != null ? implyVersionFull.getVersion() : this.cluster.getImplyVersion()).build();
        if (!this.skipValidation) {
            clusterToCreate.validate(account, (Toolbox)this.getToolbox(), true);
        }
        this.handleMagicTags(clusterToCreate, this.getContext());
        List allClusters = this.getToolbox().getClusterDataManager().getAllWithAccountId(clusterToCreate.getAccountId());
        if (account.getClusterLimit() != null && allClusters.size() >= account.getClusterLimit()) {
            throw new IAE("Failed to create cluster: limit of [%d] clusters has been reached", new Object[]{account.getClusterLimit()});
        }
        int proposedTotalMICU = this.getToolbox().getClusterUpdateHelper().getTotalMICU(account.getAccountId(), clusterToCreate);
        if (account.isValueExceedingIcuLimit(proposedTotalMICU)) {
            throw new IAE("Failed to create cluster: ICU limit of [%d] would be exceeded", new Object[]{account.getIcuLimit()});
        }
        Info accountInfo = this.getToolbox().getEntityStateDataManager().get(account);
        if (!State.CREATED.equals((Object)accountInfo.getState().getExternalState(null))) {
            throw new IAE("Failed to create cluster: accountId [%s] is not in [CREATED] state", new Object[]{account.getAccountId()});
        }
        if (implyVersionFull == null) {
            throw new IAE("Failed to create cluster: implyVersion [%s] is not supported", new Object[]{this.cluster.getImplyVersion()});
        }
        boolean isMock = !Constants.hasMagicRealTag((String)clusterToCreate.getName()) && (Constants.hasMagicMockTag((String)clusterToCreate.getName()) || this.getToolbox().getApplicationConfig().isUseMocks());
        ClusterWithExtendedInfo createdClusterWithInfo = this.getToolbox().getClusterDataManager().createWithInfo(clusterToCreate.cloner().withConfigServerKey(SecurityUtil.generateSecret((int)32)).withImplyVersionFull(implyVersionFull).withImplyVersion(implyVersionFull.getVersion()).build(), this.getDefaultInfoBuilder(clusterToCreate).withState(State.CLUSTER_INFO_RECEIVED).withDesiredState(State.CLUSTER_CREATED).withMockEntity(Boolean.valueOf(isMock)).build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), this.getToolbox().getApplicationConfig().isGroveBased(), true, true, account.getClusterLimit(), null);
        this.clearAllNotifications(createdClusterWithInfo.getCluster().key());
        this.addInfoNotification(createdClusterWithInfo.getCluster().key(), "Cluster creation requested", new Object[0]);
        this.getToolbox().getNoticeManager().queueProcessNotice(createdClusterWithInfo.getExtendedInfo().getInfo());
        return ImmutableMap.of((Object)"clusterId", (Object)createdClusterWithInfo.getCluster().getClusterId());
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.cluster != null ? 1 : 0) != 0, (Object)"[cluster] required");
        Preconditions.checkArgument((this.cluster.getAccountId() != null ? 1 : 0) != 0, (Object)"[cluster.accountId] required");
        return super.isAuthorized(principal);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cluster", (Object)this.cluster).append("context", this.getContext()).toString();
    }
}

