/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import java.util.Collection;
import java.util.Map;

public abstract class ClusterAuthenticatedAction
extends AuthenticatedAction {
    private final String clusterId;
    private String accountId;

    public ClusterAuthenticatedAction(ManagerToolbox toolbox, Map<String, String> context, String principal, String clusterId) {
        super(toolbox, context, principal);
        this.clusterId = clusterId;
    }

    protected String getClusterId() {
        return this.clusterId;
    }

    protected Info getInfo() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        return this.getToolbox().getEntityStateDataManager().get(this.clusterId);
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of((Object)this.getAccountId());
    }

    @Override
    public boolean isAuthorized(User principal) {
        return principal.getAccountIds().contains(this.getAccountId());
    }

    private String getAccountId() {
        if (this.accountId == null) {
            Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
            this.accountId = this.getToolbox().getClusterDataManager().get(this.clusterId, DeletedVisibility.SHOW_RECENT).getAccountId();
        }
        return this.accountId;
    }
}

