/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.cluster;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.ClusterAuthenticatedAction;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class CancelClusterUpdateAction
extends ClusterAuthenticatedAction {
    private final String clusterId;
    private final Boolean skipAutoRollback;

    @JsonCreator
    public CancelClusterUpdateAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="skipAutoRollback") Boolean skipAutoRollback, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, clusterId);
        this.clusterId = clusterId;
        this.skipAutoRollback = BooleanUtils.isTrue((Boolean)skipAutoRollback);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.clusterId != null ? 1 : 0) != 0, (Object)"[clusterId] required");
        Cluster cluster = this.getToolbox().getClusterDataManager().get(this.clusterId);
        this.handleMagicTags(cluster, this.getContext());
        Info existingInfo = this.getToolbox().getEntityStateDataManager().get(cluster);
        CancelClusterUpdateAction.validateState(existingInfo);
        this.getToolbox().getNoticeManager().queueNoticeAndAwaitCompletion(new CancelClusterUpdateNotice(this.getToolbox(), existingInfo, this.skipAutoRollback), true, 20000L);
        return ImmutableMap.of((Object)"clusterId", (Object)cluster.getClusterId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("clusterId", (Object)this.clusterId).append("skipAutoRollback", (Object)this.skipAutoRollback).append("context", this.getContext()).toString();
    }

    private static void validateState(Info info) {
        if (!State.CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{info.getEntityId(), info.getState(), State.CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED, State.CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        if (State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)info.getDesiredState())) {
            throw new IAE("Cannot cancel update for cluster [%s] while rolling back", new Object[]{info.getEntityId()});
        }
    }

    public static State getCancelState(Info info, Boolean skipAutoRollback) {
        if (State.CLUSTER_AGENT_UPDATE_IN_PROGRESS.equals((Object)info.getState())) {
            return State.CLUSTER_AGENT_CANCEL_UPDATE;
        }
        if (BooleanUtils.isTrue((Boolean)skipAutoRollback)) {
            return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
        }
        return State.CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED;
    }

    private static String generateNotificationString(Info info, Boolean skipAutoRollback) {
        if (State.CLUSTER_AGENT_UPDATE_IN_PROGRESS.equals((Object)info.getState())) {
            return "Cancelling cluster update";
        }
        if (BooleanUtils.isTrue((Boolean)skipAutoRollback)) {
            return "Update cancelled";
        }
        return "Cancelling and rolling back cluster update";
    }

    public static class CancelClusterUpdateNotice
    extends OperationsNotice {
        private final boolean skipAutoRollback;

        public CancelClusterUpdateNotice(ManagerToolbox toolbox, Info info, boolean skipAutoRollback) {
            super(toolbox, info);
            this.skipAutoRollback = skipAutoRollback;
        }

        @Override
        protected void innerHandle() {
            CancelClusterUpdateAction.validateState(this.info);
            this.toolbox.getEntityStateDataManager().insert(this.info, Info.builder().withState(CancelClusterUpdateAction.getCancelState(this.info, this.skipAutoRollback)).withMaxSurgeCount(this.info.getMaxSurgeCount()).withDesiredState(this.skipAutoRollback ? null : State.CLUSTER_UPDATE_ROLLED_BACK).build());
            this.addInfoNotification(CancelClusterUpdateAction.generateNotificationString(this.info, this.skipAutoRollback), new Object[0]);
            if (!this.skipAutoRollback) {
                this.toolbox.getNoticeManager().queueProcessNotice(this.info);
            }
        }

        @Generated
        public boolean isSkipAutoRollback() {
            return this.skipAutoRollback;
        }
    }
}

