/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.User;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class UpdateAccountAction
extends AccountAuthenticatedAction {
    private final Account account;

    @JsonCreator
    public UpdateAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="account") Account account, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, account != null ? account.getAccountId() : null);
        this.account = account != null ? account.cloner().withSensitiveFieldPlaceholdersRemoved().build() : null;
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.account != null ? 1 : 0) != 0, (Object)"[account] required");
        Preconditions.checkArgument((this.account.getAccountId() != null ? 1 : 0) != 0, (Object)"[account.accountId] required");
        Preconditions.checkArgument((this.account.getVersion() != null ? 1 : 0) != 0, (Object)"[account.version] required");
        Account accountToUpdate = this.account.cloner().withoutNonUpdatableFields().build();
        Account previousAccountForValidation = this.getToolbox().getAccountDataManager().get(accountToUpdate.getAccountId()).cloner().withAccount(accountToUpdate, true).build();
        previousAccountForValidation.validate(false, true, this.getToolbox().getAccountDataManager().getAll(DeletedVisibility.HIDE), this.toolbox.getRefreshableConstants());
        this.handleMagicTags(previousAccountForValidation, this.getContext());
        this.toolbox.getAccountDataManager().get(accountToUpdate.getAccountId());
        Info info = this.getToolbox().getEntityStateDataManager().get(this.account);
        if (!State.ACCOUNT_UPDATE_REQUEST_RECEIVED.getValidPreviousStates().contains(info.getState())) {
            throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{this.account.getAccountId(), info.getState(), State.ACCOUNT_UPDATE_REQUEST_RECEIVED, State.ACCOUNT_UPDATE_REQUEST_RECEIVED.getValidPreviousStates()});
        }
        String accountId = this.getToolbox().getAccountDataManager().update(accountToUpdate, ThreadLocalContext.getPrincipal().getDetailedUserId(), false, true).getAccountId();
        this.toolbox.getEntityStateDataManager().insert(info, Info.builder().withState(State.ACCOUNT_UPDATE_REQUEST_RECEIVED).withDesiredState(State.ACCOUNT_UPDATED).build());
        this.clearAllNotifications(accountToUpdate.key());
        this.getToolbox().getNoticeManager().queueProcessNotice(info);
        return ImmutableMap.of((Object)"accountId", (Object)accountId);
    }

    @Override
    public boolean isAuthorized(User principal) {
        Preconditions.checkArgument((this.account != null ? 1 : 0) != 0, (Object)"[account] required");
        Preconditions.checkArgument((this.account.getAccountId() != null ? 1 : 0) != 0, (Object)"[account.accountId] required");
        return super.isAuthorized(principal);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("account", (Object)this.account).append("context", this.getContext()).toString();
    }
}

