/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.AuthenticatedAction;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Instance;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DescribeNodesByAccountAction
extends AuthenticatedAction {
    @JsonCreator
    public DescribeNodesByAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal);
    }

    @Override
    public Object innerPerform() {
        HashMap<String, List> accountNodeMap = new HashMap<String, List>();
        for (Cluster cluster : this.getToolbox().getClusterDataManager().getAll()) {
            CloudResources clusterCloudResources = this.getToolbox().getClusterStackHelper().getClusterDetails(cluster.getClusterId(), false, false, true);
            ImmutableList nodes = clusterCloudResources == null || clusterCloudResources.getHosts() == null ? ImmutableList.of() : clusterCloudResources.getHosts().values().stream().flatMap(Collection::stream).map(Instance::getPrivateIpAddress).collect(Collectors.toList());
            accountNodeMap.compute(cluster.getAccountId(), (arg_0, arg_1) -> DescribeNodesByAccountAction.lambda$innerPerform$0((List)nodes, arg_0, arg_1));
        }
        return accountNodeMap;
    }

    @Override
    public boolean isAuthorized(User principal) {
        return false;
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return true;
    }

    @Override
    public Collection<String> getAccountIds() {
        return ImmutableList.of();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("context", this.getContext()).toString();
    }

    private static /* synthetic */ List lambda$innerPerform$0(List nodes, String k, List v) {
        if (v == null) {
            return new ArrayList(nodes);
        }
        v.addAll(nodes);
        return v;
    }
}

