/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import java.util.stream.Collectors;

public class DescribeAccountHistoryAction
extends AccountAuthenticatedAction {
    private final String accountId;

    @JsonCreator
    public DescribeAccountHistoryAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        return this.getToolbox().getAccountDataManager().getAllVersions(this.accountId).stream().map(x -> x.cloner().withSensitiveFieldsMasked().build()).collect(Collectors.toList());
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }
}

