/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action.account;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.account.AccountAuthenticatedAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AccountWithExtendedInfo;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;

public class DescribeAccountAction
extends AccountAuthenticatedAction {
    private final String accountId;

    @JsonCreator
    public DescribeAccountAction(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="context") Map<String, String> context, @JsonProperty(value="principal") String principal) {
        super(toolbox, context, principal, accountId);
        this.accountId = this.getOnPremAccountIdIfNull(accountId);
    }

    @Override
    public Object innerPerform() {
        Preconditions.checkArgument((this.accountId != null ? 1 : 0) != 0, (Object)"[accountId] required");
        Account account = this.getToolbox().getAccountDataManager().get(this.accountId);
        this.handleMagicTags(account, this.getContext());
        Info info = this.getToolbox().getEntityStateDataManager().get(account);
        CloudResources cloudResources = this.getToolbox().getNetworkStackHelper().getNetworkStackDetails(this.accountId, false, false);
        Notifications notifications = this.getToolbox().getNotificationDataManager().getAllWithEntityKey(account.key());
        return AccountWithExtendedInfo.build((Account)account.cloner().withSensitiveFieldsMasked().build(), (ExtendedInfo)ExtendedInfo.of((Info)info, (CloudResources)cloudResources, (Notifications)notifications, null, null, null, null), (boolean)true);
    }

    @Override
    public boolean isHandleableByLeaderOnly() {
        return false;
    }

    @Override
    public boolean logRequestAsDebugLevel() {
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.accountId).append("context", this.getContext()).toString();
    }
}

