/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.action;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.exception.AccessDeniedException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.BaseAction;
import io.imply.cloud.model.User;
import java.util.Map;

public abstract class AuthenticatedAction
extends BaseAction {
    @JsonProperty
    private final String principalId;

    public AuthenticatedAction(ManagerToolbox toolbox, Map<String, String> context, String principal) {
        super(toolbox, context);
        if (principal == null || principal.isEmpty()) {
            if (toolbox.isOnPrem()) {
                principal = toolbox.getManagerConfig().getSuperPrincipal();
            } else if (toolbox.getApplicationConfig().isSaaS()) {
                principal = "Saas";
            } else {
                throw new AccessDeniedException("[principal] required", new Object[0]);
            }
        }
        this.principalId = principal;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public boolean isAuthorized(User principal) {
        throw new AccessDeniedException("No access control implemented, rejecting action", new Object[0]);
    }
}

