/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.concurrent.ScheduledExecutorFactory;
import io.imply.cloud.concurrent.ScheduledExecutors;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.guice.annotations.Self;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerRunnable;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

@ManageLifecycle
public class StandaloneManager
implements ManagerLeader {
    private static final Logger log = new Logger(StandaloneManager.class);
    private final ApplicationNode self;
    private final ManagerConfig config;
    private final NoticeManager noticeManager;
    private final Object lock = new Object();
    private final ScheduledExecutorService exec;
    private volatile boolean started = false;

    @Inject
    public StandaloneManager(ScheduledExecutorFactory scheduledExecutorFactory, @Self ApplicationNode self, ManagerConfig config, NoticeManager noticeManager) {
        this.self = self;
        this.config = config;
        this.noticeManager = noticeManager;
        this.exec = scheduledExecutorFactory.create(1, "StandaloneManager-Exec-%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.startScheduler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    @Override
    public boolean isLeader() {
        return true;
    }

    @Override
    public String getCurrentLeader() {
        return this.self.getHostAndPort();
    }

    private void startScheduler() {
        if (!this.started) {
            return;
        }
        log.info("I will always and forever be the only leader, all must bow!");
        log.info("Starting management in [%s]", new Object[]{this.config.getStartupDelay().toStandardDuration()});
        ImmutableList managerRunnables = ImmutableList.of((Object)Pair.of((Object)new ManagerRunnable(this.noticeManager), (Object)this.config.getManagementPeriod().toStandardDuration()));
        for (Pair managerRunnable : managerRunnables) {
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getStartupDelay().toStandardDuration(), (Duration)((Duration)managerRunnable.rhs), () -> {
                ((ManagerRunnable)managerRunnable.lhs).run();
                return ScheduledExecutors.Signal.REPEAT;
            });
        }
    }
}

