/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.util.Logger;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import lombok.Generated;

@ManageLifecycle
public class ScheduledMetricsEmissionManager {
    @Generated
    private static final Logger log = Logger.from(ScheduledMetricsEmissionManager.class);
    private final ScheduledExecutorService executor;
    private final NoticeManager noticeManager;
    private final ManagerLeader managerLeader;
    private final ManagerConfig managerConfig;

    @Inject
    public ScheduledMetricsEmissionManager(NoticeManager noticeManager, ManagerLeader managerLeader, ManagerConfig managerConfig) {
        this(Execs.scheduledSingleThreaded((String)"ScheduledMetricsEmission"), noticeManager, managerLeader, managerConfig);
    }

    @LifecycleStart
    public void start() {
        log.info("Starting ScheduledMetricsEmissionManager");
        this.executor.scheduleWithFixedDelay(this::queueNotice, 0L, this.managerConfig.getMetricsEmissionInterval().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
    }

    @LifecycleStop
    public void stop() {
        this.executor.shutdownNow();
    }

    private void queueNotice() {
        if (!this.managerLeader.isLeader()) {
            log.debug("This node is skipping scheduled metrics emission because it is not the leader");
            return;
        }
        this.noticeManager.queueMetricsEmissionNotice();
    }

    @Generated
    ScheduledMetricsEmissionManager(ScheduledExecutorService executor, NoticeManager noticeManager, ManagerLeader managerLeader, ManagerConfig managerConfig) {
        this.executor = executor;
        this.noticeManager = noticeManager;
        this.managerLeader = managerLeader;
        this.managerConfig = managerConfig;
    }
}

