/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.spi.BindingScopingVisitor;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.notice.Notice;
import io.imply.cloud.manager.notice.operations.BulkUpdateNotice;
import io.imply.cloud.manager.notice.operations.CheckAccountGroveAgentsNotice;
import io.imply.cloud.manager.notice.operations.CheckGroveAgentsNotice;
import io.imply.cloud.manager.notice.operations.CheckInstanceHealthNotice;
import io.imply.cloud.manager.notice.operations.HandleFailingInstancesNotice;
import io.imply.cloud.manager.notice.operations.MonitorClusterHealthNotice;
import io.imply.cloud.manager.notice.operations.OperationsNotice;
import io.imply.cloud.manager.notice.operations.ProcessEntitiesNotice;
import io.imply.cloud.manager.notice.operations.RefreshConfigNotice;
import io.imply.cloud.manager.notice.operations.ScheduledMetricsEmissionNotice;
import io.imply.cloud.manager.notice.operations.ScheduledProcessEntitiesNotice;
import io.imply.cloud.model.Info;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import io.imply.cloud.util.Retryable;
import io.imply.cloud.util.ThreadUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ManageLifecycle
public class NoticeManager {
    private static final Logger log = new Logger(NoticeManager.class);
    private final RefreshableConstantsUpdater refreshableConstantsUpdater;
    private final RefreshableConstantsConfig refreshableConstantsConfig;
    private final ApplicationConfig applicationConfig;
    private final ManagerConfig managerConfig;
    private final Injector injector;
    private final Object lifecycleLock = new Object();
    private final Object handleNoticeLock = new Object();
    private final Object addNoticeLock = new Object();
    private final ExecutorService exec;
    private final ScheduledExecutorService scheduledExec;
    private final BlockingDeque<Notice> notices = new LinkedBlockingDeque<Notice>();
    private volatile boolean started = false;
    private volatile Notice notice;

    @Inject
    public NoticeManager(RefreshableConstantsUpdater refreshableConstantsUpdater, RefreshableConstantsConfig refreshableConstantsConfig, ApplicationConfig applicationConfig, ManagerConfig managerConfig, Injector injector, MetricRegistry metricRegistry) {
        this.refreshableConstantsUpdater = refreshableConstantsUpdater;
        this.refreshableConstantsConfig = refreshableConstantsConfig;
        this.applicationConfig = applicationConfig;
        this.managerConfig = managerConfig;
        this.injector = injector;
        this.exec = Execs.singleThreaded((String)"NoticeManager");
        this.scheduledExec = Execs.scheduledMultiThreaded((int)3, (String)"NoticeManager-Scheduled", null);
        metricRegistry.register(MetricRegistry.name(NoticeManager.class, (String[])new String[]{"queueLength"}), (Metric)((Gauge)this.notices::size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
            Preconditions.checkState((!this.exec.isShutdown() ? 1 : 0) != 0, (Object)"already stopped");
            this.refreshConstantsAndRescheduleOnFailure();
            this.exec.submit(() -> {
                while (!this.exec.isShutdown()) {
                    String originalThreadName = Thread.currentThread().getName();
                    try {
                        this.notice = this.notices.pollFirst(5L, TimeUnit.SECONDS);
                        Object object = this.handleNoticeLock;
                        synchronized (object) {
                            block14: {
                                if (this.notice != null) break block14;
                                continue;
                            }
                            Thread.currentThread().setName(ThreadUtils.getExtendedThreadName((String)originalThreadName, (String)this.notice.getRequesterId(), (String)this.notice.getRequestId()));
                            log.debug("Processing [%s]%s", new Object[]{this.notice.getClass().getSimpleName(), this.notice.getInfo() == null || this.notice.getInfo().getEntityId() == null || this.notice.getInfo().getEntityType() == null ? "" : String.format(" for entity [%s] (%s)", this.notice.getInfo().getEntityId(), this.notice.getInfo().getEntityType())});
                            this.notice.handle();
                            if (this.notice.isQueueNextNotice()) {
                                this.queueProcessNotice(this.notice.getInfo());
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        log.info("Main processing loop interrupted");
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        log.warn(e, "NoticeManager failed to handle notice");
                    }
                    finally {
                        Thread.currentThread().setName(originalThreadName);
                    }
                }
            });
            this.scheduledExec.scheduleAtFixedRate(() -> {
                try {
                    this.queueNotice((Notice)this.injector.getInstance(RefreshConfigNotice.class), false);
                }
                catch (Throwable e) {
                    log.error(e, "Exception thrown in notice scheduler");
                }
            }, this.refreshableConstantsConfig.getPeriod().toStandardDuration().getMillis(), this.refreshableConstantsConfig.getPeriod().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
            log.info("NoticeManager lifecycle start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            this.exec.shutdown();
            this.started = false;
            try {
                if (!this.exec.awaitTermination(4L, TimeUnit.MINUTES)) {
                    log.warn("Failed to complete all notices");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            log.info("NoticeManager has stopped");
        }
    }

    public void queueNotice(Notice notice, boolean addToQueueHead) {
        this.queueNoticeInternal(notice, addToQueueHead);
    }

    public void queueNoticeAndAwaitCompletion(Notice notice, boolean addToQueueHead, long timeoutMs) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.queueNoticeInternal(notice.withFuture(future), addToQueueHead);
        try {
            future.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNoticeInternal(Notice notice, boolean addToQueueHead) {
        final Class<?> clazz = notice.getClass();
        if (!OperationsNotice.class.isAssignableFrom(clazz)) {
            this.injector.getBinding(clazz).acceptScopingVisitor((BindingScopingVisitor)new BindingScopingVisitor<Object>(){

                public Object visitEagerSingleton() {
                    throw new ISE("%s cannot have a scope assigned!", new Object[]{clazz.getSimpleName()});
                }

                public Object visitScope(Scope scope) {
                    throw new ISE("%s cannot have a scope assigned!", new Object[]{clazz.getSimpleName()});
                }

                public Object visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                    throw new ISE("%s cannot have a scope assigned!", new Object[]{clazz.getSimpleName()});
                }

                public Object visitNoScoping() {
                    return null;
                }
            });
        }
        Object object = this.addNoticeLock;
        synchronized (object) {
            if (addToQueueHead) {
                this.notices.addFirst(notice);
            } else {
                this.notices.addLast(notice);
            }
        }
    }

    public void queueNotice(Class<? extends Notice> clazz, Info info, Map<String, Object> customData, boolean addToQueueHead) {
        Preconditions.checkNotNull(clazz);
        Class annotatedType = info != null ? info.getAnnotatedType() : null;
        Notice notice = null;
        try {
            try {
                if (annotatedType != null) {
                    notice = (Notice)this.injector.getInstance(Key.get(clazz, (Class)annotatedType));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (notice == null) {
                notice = (Notice)this.injector.getInstance(clazz);
            }
            this.queueNotice(notice.withInfo(info).withCustomData(customData), addToQueueHead);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception thrown while attempting to queue notice");
        }
    }

    public void queueProcessNotice(Info info) {
        this.queueNotice(((ProcessEntitiesNotice)this.injector.getInstance(ProcessEntitiesNotice.class)).withAddToQueueHead(true).withInfo(info), true);
    }

    public void queueScheduledProcessNotice() {
        this.queueSingletonNotice(ScheduledProcessEntitiesNotice.class);
    }

    public void queueCheckInstanceHealthNotice() {
        if (!this.managerConfig.isSkipClusterHealthChecks()) {
            this.queueSingletonNotice(CheckInstanceHealthNotice.class);
        }
    }

    public void queueCheckGroveAgentsNotice() {
        if (this.applicationConfig.isGroveBased()) {
            this.queueSingletonNotice(CheckGroveAgentsNotice.class);
        }
    }

    public void queueCheckAccountGroveAgentsNotice(Info info) {
        if (!this.applicationConfig.isGroveBased()) {
            return;
        }
        try {
            if (this.notices.contains(this.injector.getInstance(CheckGroveAgentsNotice.class))) {
                return;
            }
            Boolean hasAccountNotice = this.notices.stream().anyMatch(x -> CheckAccountGroveAgentsNotice.class.isAssignableFrom(x.getClass()) && x.getInfo().getEntityId().equals(info.getEntityId()));
            if (!hasAccountNotice.booleanValue()) {
                this.queueNotice(((CheckAccountGroveAgentsNotice)this.injector.getInstance(CheckAccountGroveAgentsNotice.class)).withInfo(info), false);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception thrown while attempting to queue notice");
        }
    }

    public void queueHandleFailingInstancesNotice() {
        if (!this.applicationConfig.isGroveBased() && !this.managerConfig.isSkipClusterHealthChecks()) {
            this.queueSingletonNotice(HandleFailingInstancesNotice.class);
        }
    }

    public void queueBulkUpdateNotice() {
        if (this.applicationConfig.isSaaS()) {
            this.queueSingletonNotice(BulkUpdateNotice.class);
        }
    }

    public void queueMonitorClusterHealthNotice() {
        if (this.applicationConfig.isAWS()) {
            log.debug("Queueing MonitorClusterHealthNotice");
            this.queueSingletonNotice(MonitorClusterHealthNotice.class);
        }
    }

    public void queueMetricsEmissionNotice() {
        this.queueSingletonNotice(ScheduledMetricsEmissionNotice.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T clearNoticesForEntityId(String entityId, Callable<T> callback) {
        if (entityId == null) {
            return null;
        }
        Object object = this.handleNoticeLock;
        synchronized (object) {
            Object object2 = this.addNoticeLock;
            synchronized (object2) {
                this.notices.removeIf(x -> x.getInfo() != null && entityId.equals(x.getInfo().getEntityId()));
                if (this.notice != null && this.notice.getInfo() != null && entityId.equals(this.notice.getInfo().getEntityId())) {
                    this.notice = null;
                }
            }
            if (callback == null) {
                return null;
            }
            try {
                return callback.call();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void queueSingletonNotice(Class<? extends Notice> noticeClass) {
        try {
            Notice notice = (Notice)this.injector.getInstance(noticeClass);
            if (!this.notices.contains(notice)) {
                this.queueNotice(notice, false);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception thrown in notice scheduler");
        }
    }

    private void refreshConstantsAndRescheduleOnFailure() {
        Retryable.of(() -> ((RefreshableConstantsUpdater)this.refreshableConstantsUpdater).seed(), (int)2, (int)2, e -> this.scheduledExec.schedule(this::refreshConstantsAndRescheduleOnFailure, 30L, TimeUnit.SECONDS), (boolean)true);
    }
}

