/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.MapboxClient;
import javax.inject.Inject;
import lombok.Generated;

@LazySingleton
public class MapboxManager {
    @Generated
    private static final Logger log = Logger.from(MapboxManager.class);
    private final MapboxClient mapboxClient;
    private final ClusterDataManager clusterDataManager;
    private final EntityStateDataManager entityStateDataManager;
    private final AccountDataManager accountDataManager;

    public boolean maybeUpdateMapboxToken(String clusterId, boolean updateVersion) {
        return this.maybeUpdateMapboxToken(Cluster.builder().withClusterId(clusterId).build(), updateVersion);
    }

    public boolean maybeUpdateMapboxToken(Cluster toUpdate, boolean updateVersion) {
        Cluster cluster = this.clusterDataManager.get(toUpdate.getClusterId());
        if (this.mapboxClient.isConfigured() && (cluster.getMapbox() == null || !this.mapboxClient.isValid(cluster.getMapbox()))) {
            log.info("Updating mapbox token for cluster [%s]", new Object[]{cluster.getClusterId()});
            Account account = this.accountDataManager.get(cluster.getAccountId());
            this.mapboxClient.createToken(account, cluster).ifPresent(mapbox -> this.clusterDataManager.updateWithInfo(cluster.cloner().withMapbox(mapbox).build(), this.entityStateDataManager.get(cluster), "SYSTEM", true, true, updateVersion, updateVersion, true));
            return true;
        }
        return false;
    }

    public void deleteToken(Cluster cluster) {
        this.mapboxClient.deleteToken(cluster.getMapbox());
    }

    @Inject
    @Generated
    public MapboxManager(MapboxClient mapboxClient, ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, AccountDataManager accountDataManager) {
        this.mapboxClient = mapboxClient;
        this.clusterDataManager = clusterDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.accountDataManager = accountDataManager;
    }
}

