/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.guice.annotations.Self;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.util.ToStringBuilder;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.Period;

public class ManagerConfig {
    private static final long DEFAULT_CLUSTER_MONITORING_INTERVAL_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    protected final ApplicationConfig applicationConfig;
    protected final ApplicationNode applicationNode;
    @JsonProperty
    private Period startupDelay = new Period((Object)"PT5S");
    @JsonProperty
    private Period updateDelay = new Period((Object)"PT5M");
    @JsonProperty
    private Period managementPeriod;
    @JsonProperty
    private String superPrincipal = "20c206ae-cce1-4b57-8d63-9b4444c9dfbd";
    @JsonProperty(value="dev.useInstancePublicIp")
    private Boolean useInstancePublicIp = false;
    @JsonProperty(value="dev.useDynamicMasterIp")
    private Boolean useDynamicMasterIp = false;
    @JsonProperty(value="dev.retainFailedClusters")
    private Boolean retainFailedClusters = false;
    @JsonProperty(value="dev.retainInstanceOnFailedInit")
    private Boolean retainInstanceOnFailedInit = false;
    @JsonProperty(value="dev.skipRdsSnapshotOnUpdate")
    private Boolean skipRdsSnapshotOnUpdate = false;
    @JsonProperty(value="dev.skipRemoveS3TemplateAccessOnDelete")
    private Boolean skipRemoveS3TemplateAccessOnDelete;
    @JsonProperty(value="dev.skipClusterReadyValidation")
    private Boolean skipClusterReadyValidation = false;
    @JsonProperty
    private Period proxyTimeout = new Period((Object)"PT30S");
    @JsonProperty
    private String configServerUrl;
    @JsonProperty
    private String certificateStoreRoute = "/auth/v1/certificates/";
    @JsonProperty
    private boolean includeSelfAsAgent = false;
    @JsonProperty
    private boolean skipClusterHealthChecks = false;
    @JsonProperty
    private long clusterMonitoringIntervalSeconds = DEFAULT_CLUSTER_MONITORING_INTERVAL_SECONDS;
    @JsonProperty
    private String clusterAlarmSlackWebHookUrl;
    @JsonProperty
    private Period metricsEmissionInterval = new Period((Object)"PT12M");
    @JsonProperty
    private Period taskReportsEmissionInterval = new Period((Object)"PT30M");
    @JsonProperty
    private boolean emitProjectSizeToDropwizard = true;

    @JsonCreator
    public ManagerConfig(@JacksonInject ApplicationConfig applicationConfig, @JacksonInject @Self ApplicationNode applicationNode) {
        this.applicationConfig = applicationConfig;
        this.applicationNode = applicationNode;
    }

    public Period getStartupDelay() {
        return this.startupDelay;
    }

    public Period getManagementPeriod() {
        return this.managementPeriod != null ? this.managementPeriod : (this.applicationConfig.isDevelopmentMode() ? new Period((Object)"PT15S") : new Period((Object)"PT30S"));
    }

    public String getSuperPrincipal() {
        return this.superPrincipal;
    }

    public Boolean isUseInstancePublicIp() {
        return this.useInstancePublicIp;
    }

    public Boolean isUseDynamicMasterIp() {
        return this.useDynamicMasterIp;
    }

    public Boolean isRetainFailedClusters() {
        return this.retainFailedClusters;
    }

    public boolean isRetainInstanceOnFailedInit() {
        return BooleanUtils.isTrue((Boolean)this.retainInstanceOnFailedInit);
    }

    public Boolean isSkipRdsSnapshotOnUpdate() {
        return this.skipRdsSnapshotOnUpdate != null ? this.skipRdsSnapshotOnUpdate.booleanValue() : this.applicationConfig.isDevelopmentMode();
    }

    public Boolean isSkipRemoveS3TemplateAccessOnDelete() {
        return this.skipRemoveS3TemplateAccessOnDelete != null ? this.skipRemoveS3TemplateAccessOnDelete.booleanValue() : this.applicationConfig.isDevelopmentMode();
    }

    public Boolean isSkipClusterReadyValidation() {
        return this.skipClusterReadyValidation;
    }

    public Period getProxyTimeout() {
        return this.proxyTimeout;
    }

    public String getConfigServerUrl() {
        return this.configServerUrl != null ? this.configServerUrl : String.format("http://%s", this.applicationNode.getHostAndPort());
    }

    public String getCertificateStoreRoute() {
        return this.certificateStoreRoute;
    }

    public boolean isIncludeSelfAsAgent() {
        return this.includeSelfAsAgent;
    }

    public boolean isSkipClusterHealthChecks() {
        return this.skipClusterHealthChecks;
    }

    public long getClusterMonitoringIntervalInSeconds() {
        return this.clusterMonitoringIntervalSeconds;
    }

    public String getClusterAlarmSlackWebHookUrl() {
        return this.clusterAlarmSlackWebHookUrl;
    }

    public Period getMetricsEmissionInterval() {
        return this.metricsEmissionInterval;
    }

    public Period getTaskReportsEmissionInterval() {
        return this.taskReportsEmissionInterval;
    }

    public boolean isEmitProjectSizeToDropwizard() {
        return this.emitProjectSizeToDropwizard;
    }

    public String toString() {
        if (this.applicationConfig == null || this.applicationConfig.isOnPrem()) {
            return super.toString();
        }
        return new ToStringBuilder((Object)this).append("applicationConfig", (Object)this.applicationConfig).append("startupDelay", (Object)this.startupDelay).append("updateDelay", (Object)this.updateDelay).append("managementPeriod", (Object)this.managementPeriod).append("superPrincipal", (Object)this.superPrincipal).append("useInstancePublicIp", (Object)this.useInstancePublicIp).append("useDynamicMasterIp", (Object)this.useDynamicMasterIp).append("retainFailedClusters", (Object)this.retainFailedClusters).append("retainInstanceOnFailedInit", (Object)this.retainInstanceOnFailedInit).append("skipRdsSnapshotOnUpdate", (Object)this.skipRdsSnapshotOnUpdate).append("skipRemoveS3TemplateAccessOnDelete", (Object)this.skipRemoveS3TemplateAccessOnDelete).append("skipClusterReadyValidation", (Object)this.skipClusterReadyValidation).append("proxyTimeout", (Object)this.proxyTimeout).append("configServerUrl", (Object)this.configServerUrl).append("certificateStoreRoute", (Object)this.certificateStoreRoute).append("includeSelfAsAgent", this.includeSelfAsAgent).append("skipClusterHealthChecks", this.skipClusterHealthChecks).append("clusterMonitorPeriodSeconds", this.clusterMonitoringIntervalSeconds).append("clusterAlarmSlackWebHookUrl", (Object)this.clusterAlarmSlackWebHookUrl).toString();
    }

    @Generated
    public Period getUpdateDelay() {
        return this.updateDelay;
    }
}

