/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.google.inject.Inject;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.cluster.TerminateInstanceAction;
import io.imply.cloud.manager.notice.cluster.SetFrequentStatusRefreshPeriodNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ThreadLocalContext;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class InstanceManager {
    private final ManagerToolbox toolbox;
    private final ClusterDataManager clusterDataManager;

    public void replace(@NotNull String clusterId, @NotNull String instanceId) {
        ThreadLocalContext.setNoticeOrActionClass(TerminateInstanceAction.class);
        Cluster cluster = this.clusterDataManager.get(clusterId);
        this.toolbox.getNodeHelper().restartNode(cluster, instanceId);
        this.toolbox.getNoticeManager().queueNotice(new SetFrequentStatusRefreshPeriodNotice(this.toolbox, cluster), true);
        this.toolbox.getClusterStackHelper().refreshClusterDetails(clusterId);
    }

    @Inject
    @Generated
    public InstanceManager(ManagerToolbox toolbox, ClusterDataManager clusterDataManager) {
        this.toolbox = toolbox;
        this.clusterDataManager = clusterDataManager;
    }
}

