/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.ExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.Logger;
import java.util.HashMap;

public class DescribeClusterHelper {
    private static final Logger log = new Logger(DescribeClusterHelper.class);

    public static ClusterWithExtendedInfo describeCluster(ManagerToolbox toolbox, String clusterId, boolean showNotifications) {
        Cluster cluster = toolbox.getClusterDataManager().get(clusterId, DeletedVisibility.SHOW_RECENT);
        Info info = toolbox.getEntityStateDataManager().get(cluster);
        CloudResources clusterCloudResources = null;
        try {
            clusterCloudResources = toolbox.getClusterStackHelper().getClusterDetails(clusterId, false, false, false);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to retrieve cluster resource data");
        }
        CloudResources networkCloudResources = toolbox.getNetworkStackHelper().getNetworkStackDetails(cluster.getAccountId(), false, false, 900);
        HashMap combinedUrls = new HashMap();
        if (clusterCloudResources != null && clusterCloudResources.getUrls() != null) {
            combinedUrls.putAll(clusterCloudResources.getUrls());
        }
        if (networkCloudResources != null && networkCloudResources.getUrls() != null) {
            combinedUrls.putAll(networkCloudResources.getUrls());
        }
        Notifications notifications = showNotifications ? toolbox.getNotificationDataManager().getAllWithEntityKey(cluster.key()) : null;
        String configServerUrl = toolbox.getManagerConfig().getConfigServerUrl();
        String rootCertificateUrl = cluster.getSecurityConfiguration() != null && cluster.getSecurityConfiguration().getRootCertificate() != null ? String.format("%s%s%s", configServerUrl, toolbox.getManagerConfig().getCertificateStoreRoute(), cluster.getClusterId()) : null;
        ClusterNodes clusterNodes = null;
        if (toolbox.getApplicationConfig().isGroveBased()) {
            clusterNodes = toolbox.getClusterNodesDataManager().getOrNull(clusterId);
        }
        return ClusterWithExtendedInfo.build((Cluster)cluster.cloner().withSensitiveFieldsMasked().build(), (ExtendedInfo)ExtendedInfo.of((Info)info, (CloudResources)CloudResources.builder().withCloudResources(clusterCloudResources).withUrls(combinedUrls).build(), (Notifications)notifications, (String)rootCertificateUrl, (ClusterNodes)clusterNodes, (Boolean)cluster.isLogviewSupported(), (Boolean)toolbox.getApplicationConfig().isKubernetesMode()), (!toolbox.getApplicationConfig().isSaaS() && !toolbox.getApplicationConfig().isIOW() ? 1 : 0) != 0, (boolean)true);
    }
}

