/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.concurrent.ScheduledExecutorFactory;
import io.imply.cloud.concurrent.ScheduledExecutors;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.guice.annotations.Self;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerRunnable;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.server.curator.ZkPathsConfig;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import io.imply.telemetry.Event;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.Duration;

@ManageLifecycle
public class CuratorManager
implements ManagerLeader {
    private static final String MANAGER_OWNER_NODE = "_MANAGER";
    private static final Logger log = new Logger(CuratorManager.class);
    private final CuratorFramework curator;
    private final ZkPathsConfig zkPaths;
    private final ApplicationNode self;
    private final ManagerConfig config;
    private final NoticeManager noticeManager;
    private final MetricRegistry metricRegistry;
    private final Object lock = new Object();
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final ScheduledExecutorService exec;
    private volatile boolean started = false;
    private volatile boolean leader = false;
    private volatile int leaderCounter = 0;

    @Inject
    public CuratorManager(ScheduledExecutorFactory scheduledExecutorFactory, CuratorFramework curator, ZkPathsConfig zkPaths, @Self ApplicationNode self, ManagerConfig config, NoticeManager noticeManager, MetricRegistry metricRegistry) {
        this.curator = curator;
        this.zkPaths = zkPaths;
        this.self = self;
        this.config = config;
        this.noticeManager = noticeManager;
        this.metricRegistry = metricRegistry;
        this.exec = scheduledExecutorFactory.create(1, "CuratorManager-Exec-%d");
        this.leaderLatch = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createNewLeaderLatch();
            try {
                this.leaderLatch.get().start();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            this.metricRegistry.register(Event.name((String)MetricRegistry.name(CuratorManager.class, (String[])new String[]{"leader"}), (String[])new String[0]), (Metric)((Gauge)() -> this.isLeader() ? 1 : 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.stopBeingLeader();
            try {
                this.leaderLatch.get().close();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Unable to close leaderLatch, ignoring");
            }
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    @Override
    public boolean isLeader() {
        return this.leader;
    }

    @Override
    public String getCurrentLeader() {
        try {
            LeaderLatch latch = this.leaderLatch.get();
            if (latch == null) {
                return null;
            }
            Participant participant = latch.getLeader();
            if (participant.isLeader()) {
                return participant.getId();
            }
            return null;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private LeaderLatch createNewLeaderLatch() {
        LeaderLatch newLeaderLatch = new LeaderLatch(this.curator, ZKPaths.makePath((String)this.zkPaths.getManagerPath(), (String)MANAGER_OWNER_NODE), this.self.getHostAndPort());
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                CuratorManager.this.becomeLeader();
            }

            public void notLeader() {
                CuratorManager.this.stopBeingLeader();
            }
        }, (Executor)Execs.singleThreaded((String)"ManagerLeader-%s"));
        return this.leaderLatch.getAndSet(newLeaderLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the managers, all must bow!");
            log.info("Starting management in [%s]", new Object[]{this.config.getStartupDelay().toStandardDuration()});
            try {
                ++this.leaderCounter;
                this.leader = true;
                final int startingLeaderCounter = this.leaderCounter;
                ArrayList managerRunnables = Lists.newArrayList();
                managerRunnables.add(Pair.of((Object)new CuratorManagerRunnable(startingLeaderCounter), (Object)this.config.getManagementPeriod().toStandardDuration()));
                for (final Pair managerRunnable : managerRunnables) {
                    ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getStartupDelay().toStandardDuration(), (Duration)((Duration)managerRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                        private final CuratorManagerRunnable theRunnable;
                        {
                            this.theRunnable = (CuratorManagerRunnable)managerRunnable.lhs;
                        }

                        @Override
                        public ScheduledExecutors.Signal call() {
                            if (CuratorManager.this.leader && startingLeaderCounter == CuratorManager.this.leaderCounter) {
                                this.theRunnable.run();
                            }
                            if (CuratorManager.this.leader && startingLeaderCounter == CuratorManager.this.leaderCounter) {
                                return ScheduledExecutors.Signal.REPEAT;
                            }
                            return ScheduledExecutors.Signal.STOP;
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to become leader");
                LeaderLatch oldLatch = this.createNewLeaderLatch();
                IOUtils.closeQuietly((Closeable)oldLatch);
                try {
                    this.leaderLatch.get().start();
                }
                catch (Exception e1) {
                    log.error((Throwable)e1, "I am a zombie");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ++this.leaderCounter;
                log.info("I am no longer the leader...");
                this.leader = false;
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to stopBeingLeader");
            }
        }
    }

    public class CuratorManagerRunnable
    extends ManagerRunnable {
        private final int startingLeaderCounter;

        protected CuratorManagerRunnable(int startingLeaderCounter) {
            super(CuratorManager.this.noticeManager);
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = CuratorManager.this.lock;
                synchronized (object) {
                    LeaderLatch latch = CuratorManager.this.leaderLatch.get();
                    if (latch == null || !latch.hasLeadership()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{latch == null ? null : latch.getLeader().getId()});
                        CuratorManager.this.stopBeingLeader();
                        return;
                    }
                }
                if (CuratorManager.this.leader && this.startingLeaderCounter == CuratorManager.this.leaderCounter) {
                    super.run();
                }
            }
            catch (Throwable e) {
                log.error(e, "Caught exception, ignoring so that schedule keeps going.");
            }
        }
    }
}

