/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.util.Logger;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@ManageLifecycle
public class ClusterMonitoringManager {
    private static final Logger log = new Logger(ClusterMonitoringManager.class);
    private final ScheduledExecutorService scheduledExec = Execs.scheduledSingleThreaded((String)"ClusterMonitoringManager-Scheduled");
    private final NoticeManager noticeManager;
    private final ManagerLeader managerLeader;
    private final ManagerConfig managerConfig;
    private boolean started = false;

    @Inject
    public ClusterMonitoringManager(NoticeManager noticeManager, ManagerLeader managerLeader, ManagerConfig managerConfig) {
        this.noticeManager = noticeManager;
        this.managerLeader = managerLeader;
        this.managerConfig = managerConfig;
    }

    @LifecycleStart
    public void start() {
        this.started = true;
        log.info("Starting ClusterMonitoringManager");
        this.scheduledExec.scheduleAtFixedRate(() -> this.queueMonitorClusterHealthNotice(), 0L, this.managerConfig.getClusterMonitoringIntervalInSeconds(), TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void queueMonitorClusterHealthNotice() {
        try {
            if (!this.managerLeader.isLeader()) {
                log.debug("This node is skipping scheduling cluster monitoring checks because it is not the leader");
                return;
            }
            this.noticeManager.queueMonitorClusterHealthNotice();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "An error occurred when scheduling cluster monitoring checks.");
        }
    }

    @LifecycleStop
    public void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        this.scheduledExec.shutdownNow();
        this.started = false;
        log.debug("ClusterMonitoringManager has stopped");
    }
}

