/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager;

import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.Toolbox;
import io.imply.cloud.exception.NotModifiedException;
import io.imply.cloud.exception.ObjectNotFoundException;
import io.imply.cloud.manager.DescribeClusterHelper;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.action.Action;
import io.imply.cloud.manager.action.cluster.CancelClusterUpdateAction;
import io.imply.cloud.manager.action.cluster.CreateClusterAction;
import io.imply.cloud.manager.action.cluster.DeleteClusterAction;
import io.imply.cloud.manager.action.cluster.DescribeClusterAction;
import io.imply.cloud.manager.action.cluster.DescribeClustersAction;
import io.imply.cloud.manager.action.cluster.PauseClusterAction;
import io.imply.cloud.manager.action.cluster.RestartClusterAction;
import io.imply.cloud.manager.action.cluster.RetryClusterUpdateAction;
import io.imply.cloud.manager.action.cluster.RollbackClusterUpdateAction;
import io.imply.cloud.manager.action.cluster.StartClusterAction;
import io.imply.cloud.manager.action.cluster.StopClusterAction;
import io.imply.cloud.manager.action.cluster.UpdateClusterAction;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AuditEntry;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Region;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.AuditDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.DiffResultHelper;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.JSON;
import io.imply.cloud.util.SecurityUtil;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;

public class ClusterManager {
    private static final List<String> INFO_ONLY_FIELDS = ImmutableList.of((Object)"version", (Object)"name", (Object)"accountId", (Object)"metadata", (Object)"comments", (Object)"deletionProtection", (Object)"stopProtection");
    private final ManagerToolbox toolbox;
    private final ClusterDataManager clusterDataManager;
    private final AccountDataManager accountDataManager;
    private final ManagerLeader managerLeader;
    private final AuditDataManager auditDataManager;

    public Cluster validate(@NotNull @Valid Cluster rawCluster, Boolean setCreationOnlyDefaults) {
        Cluster.Builder clusterBuilder = rawCluster.cloner().withDefaultsForUnset(this.toolbox.getApplicationConfig(), setCreationOnlyDefaults.booleanValue(), this.toolbox.getInstanceTypeHelper());
        if (setCreationOnlyDefaults.booleanValue()) {
            ImplyVersion implyVersionFull = this.getImplyVersion(rawCluster);
            clusterBuilder.withImplyVersionFull(implyVersionFull).withImplyVersion(implyVersionFull.getVersion());
        } else {
            this.maybeGetClusterImplyVersion(rawCluster).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withImplyVersionFull(arg_0));
        }
        Cluster cluster = clusterBuilder.build();
        cluster.validate(this.accountDataManager.get(cluster.getAccountId()), (Toolbox)this.toolbox, true);
        return cluster;
    }

    public Cluster create(@NotNull @Valid Cluster rawCluster) {
        return this.create(rawCluster, null);
    }

    public Cluster create(@NotNull @Valid Cluster rawCluster, Region region) {
        Account account = this.accountDataManager.get(rawCluster.getAccountId());
        ImplyVersion implyVersionFull = this.getImplyVersion(rawCluster);
        rawCluster = this.toolbox.getClusterUpdateHelper().maybeRemapDataInstanceTiersForBlueGreenDeployment(rawCluster, rawCluster, UpdateType.ROLLING);
        Cluster cluster = rawCluster.cloner().withDefaultsForUnset(this.toolbox.getApplicationConfig(), true, this.toolbox.getInstanceTypeHelper()).withoutNonUpdatableFields().withImplyVersionFull(implyVersionFull).withImplyVersion(implyVersionFull.getVersion()).build();
        cluster.validate(this.accountDataManager.get(cluster.getAccountId()), (Toolbox)this.toolbox, true);
        this.assertValidAccountState(account);
        this.assertICULimitNotExceeded(account, cluster);
        ClusterWithExtendedInfo extendedCluster = this.toolbox.getClusterDataManager().createWithInfo(cluster.cloner().withConfigServerKey(SecurityUtil.generateSecret((int)32)).build(), cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_INFO_RECEIVED).withDesiredState(State.CLUSTER_CREATED).withMockEntity(Boolean.valueOf(this.toolbox.getApplicationConfig().isUseMocks())).build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), this.toolbox.getApplicationConfig().isGroveBased(), true, true, account.getClusterLimit(), region);
        this.auditAction(cluster, new CreateClusterAction(this.toolbox, cluster, null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(extendedCluster.getCluster().key());
        this.addInfoNotification(extendedCluster.getCluster().key(), "Cluster creation requested");
        this.queueProcessNotice(extendedCluster.getExtendedInfo().getInfo());
        return extendedCluster.getCluster();
    }

    public Cluster replace(Cluster rawCluster, UpdateType updateType) {
        Cluster originalCluster = this.clusterDataManager.get(rawCluster.getClusterId());
        Info info = this.toolbox.getEntityStateDataManager().get(originalCluster);
        Account account = this.accountDataManager.get(rawCluster.getAccountId());
        rawCluster = this.toolbox.getClusterUpdateHelper().maybeRemapDataInstanceTiersForBlueGreenDeployment(originalCluster, rawCluster, updateType);
        Cluster.Builder clusterBuilder = rawCluster.cloner().withNonUpdatableFields(originalCluster).withDefaultsForUnset(this.toolbox.getApplicationConfig(), false, this.toolbox.getInstanceTypeHelper());
        this.maybeGetClusterImplyVersion(rawCluster).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withImplyVersionFull(arg_0));
        Cluster cluster = clusterBuilder.build();
        cluster.validate(account, (Toolbox)this.toolbox, false);
        DiffResult diffs = originalCluster.diff(cluster);
        if (DiffResultHelper.isEmpty((DiffResult)diffs, (String[])new String[]{"version", "comments"})) {
            throw new NotModifiedException();
        }
        if (!DiffResultHelper.contains((DiffResult)diffs, (String)"customDruidProperties")) {
            cluster = cluster.cloner().withCustomDruidProperties(originalCluster.getCustomDruidProperties()).build();
        }
        List<UpdateDetails> updateDetails = this.toolbox.getClusterUpdateHelper().getUpdateDetailsForClusterDiff((DiffResult<Cluster>)diffs);
        this.assertUpdateSupported(updateDetails);
        if (info.getState().isStoppedTerminatedOrFailed() || DiffResultHelper.isEmpty((DiffResult)diffs, INFO_ONLY_FIELDS)) {
            Cluster toReturn = this.toolbox.getClusterDataManager().updateWithInfo(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), true, false, true, true, false).getCluster();
            this.auditAction(cluster, new UpdateClusterAction(this.toolbox, updateType, cluster, null, ThreadLocalContext.getPrincipal().getDetailedUserId(), null));
            return toReturn;
        }
        this.assertUpdateTypeSupported(updateDetails, updateType);
        this.assertValidClusterStateChange(originalCluster, State.CLUSTER_UPDATE_REQUEST_RECEIVED);
        this.assertICULimitNotExceeded(account, cluster);
        cluster.validateClusterInUpdatableState((Toolbox)this.toolbox);
        Pair<Map<String, Object>, Map<String, Object>> parameters = this.getParameters(originalCluster, cluster);
        ClusterWithExtendedInfo extendedCluster = this.toolbox.getClusterDataManager().updateWithInfo(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(updateType).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).modifiedParameters((Map)parameters.getRight()).originalParameters((Map)parameters.getLeft()).supportedTypes(this.getSupportedUpdateTypes(updateDetails, updateType)).build()).clearExistingUpdateState().build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), true, false, false, false, true);
        this.auditAction(cluster, new UpdateClusterAction(this.toolbox, updateType, cluster, null, ThreadLocalContext.getPrincipal().getDetailedUserId(), null));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster update requested");
        this.queueProcessNotice(extendedCluster.getExtendedInfo().getInfo());
        return extendedCluster.getCluster();
    }

    public void delete(@NotNull String clusterId) {
        this.delete(this.clusterDataManager.get(clusterId));
    }

    public void delete(@NotNull Cluster cluster) {
        if (BooleanUtils.isTrue((Boolean)cluster.isDeletionProtection())) {
            throw new ISE("Deletion protection is enabled", new Object[0]);
        }
        Info info = this.toolbox.getNoticeManager().clearNoticesForEntityId(cluster.getClusterId(), () -> this.toolbox.getEntityStateDataManager().insert(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_DELETE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_DELETED).withNotificationCutoff(DateTime.now()).build()));
        this.auditAction(cluster, new DeleteClusterAction(this.toolbox, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster deletion requested");
        this.queueProcessNotice(info);
    }

    public Cluster start(String clusterId) {
        Cluster cluster = this.clusterDataManager.get(clusterId);
        Account account = this.accountDataManager.get(cluster.getAccountId());
        this.assertValidClusterStateChange(cluster, State.CLUSTER_START_REQUEST_RECEIVED);
        this.assertICULimitNotExceeded(account, cluster);
        cluster.validate(this.accountDataManager.get(cluster.getAccountId()), (Toolbox)this.toolbox, false);
        Info info = this.toolbox.getEntityStateDataManager().insert(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_START_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_STARTED).build());
        this.auditAction(cluster, new StartClusterAction(this.toolbox, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster start requested");
        this.queueProcessNotice(info);
        return cluster;
    }

    public Cluster stop(String clusterId) {
        Cluster cluster = this.toolbox.getClusterDataManager().get(clusterId);
        if (BooleanUtils.isTrue((Boolean)cluster.isStopProtection())) {
            throw new ISE("Stop protection is enabled", new Object[0]);
        }
        Info info = this.toolbox.getNoticeManager().clearNoticesForEntityId(clusterId, () -> this.toolbox.getEntityStateDataManager().insert(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_STOP_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_STOPPED).build()));
        this.auditAction(cluster, new StopClusterAction(this.toolbox, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster stop requested");
        this.queueProcessNotice(info);
        return cluster;
    }

    public Cluster pause(String clusterId) {
        Cluster cluster = this.toolbox.getClusterDataManager().get(clusterId);
        if (BooleanUtils.isTrue((Boolean)cluster.isStopProtection())) {
            throw new ISE("Stop protection is enabled", new Object[0]);
        }
        if (FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.USE_LOCAL_STORAGE, (RefreshableConstants)this.toolbox.getRefreshableConstants())) {
            return this.stop(clusterId);
        }
        Info info = this.toolbox.getNoticeManager().clearNoticesForEntityId(clusterId, () -> this.toolbox.getEntityStateDataManager().insert(cluster, cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_STOP_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_PAUSED).build()));
        this.auditAction(cluster, new PauseClusterAction(this.toolbox, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster pause requested");
        this.queueProcessNotice(info);
        return cluster;
    }

    public Cluster restart(String clusterId, UpdateType updateType) {
        Cluster cluster = this.clusterDataManager.get(clusterId);
        this.assertValidClusterStateChange(cluster, State.CLUSTER_RESTART_REQUEST_RECEIVED);
        ArrayList<UpdateDetails> possibleUpdateTypes = new ArrayList<UpdateDetails>();
        possibleUpdateTypes.add(UpdateDetails.hard((int)10));
        if (this.toolbox.getClusterUpdateHelper().canSupportRollingUpdates(cluster)) {
            possibleUpdateTypes.add(UpdateDetails.rolling((int)30));
        }
        this.assertUpdateTypeSupported(possibleUpdateTypes, updateType);
        Info.Builder updateInfoBuilder = cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_RESTART_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATED).withUpdateType(updateType).withProposedClusterNodesVersion(Constants.CLEAR_FIELD_INT).withUpdateState(UpdateState.builder().currentState(State.CLUSTER_UPDATE_REQUEST_RECEIVED).supportedTypes(this.getSupportedUpdateTypes(possibleUpdateTypes, updateType)).build()).clearExistingUpdateState();
        ClusterWithExtendedInfo updatedClusterWithInfo = this.toolbox.getClusterDataManager().updateWithInfo(cluster, updateInfoBuilder.build(), ThreadLocalContext.getPrincipal().getDetailedUserId(), true, true, false, false, true);
        this.auditAction(cluster, new RestartClusterAction(this.toolbox, cluster.getClusterId(), updateType, null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(updatedClusterWithInfo.getCluster().key());
        this.addInfoNotification(updatedClusterWithInfo.getCluster().key(), "Cluster restart requested");
        this.queueProcessNotice(updatedClusterWithInfo.getExtendedInfo().getInfo());
        return updatedClusterWithInfo.getCluster();
    }

    public Cluster retry(String clusterId, UpdateType updateType) {
        Cluster cluster = this.clusterDataManager.get(clusterId);
        Info existingInfo = this.toolbox.getEntityStateDataManager().getOrNull(cluster);
        this.assertValidClusterStateChange(cluster, State.CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED);
        this.assertUpdateTypeChangeSupported(existingInfo, clusterId, updateType);
        Info.Builder infoBuilder = cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED).withNotificationCutoff(DateTime.now()).withUpdateType(updateType);
        Info info = this.toolbox.getEntityStateDataManager().insert(cluster, infoBuilder.build());
        boolean performingRollback = info.getUpdateState() != null && BooleanUtils.isTrue((Boolean)info.getUpdateState().getPerformingRollback());
        this.auditAction(cluster, new RetryClusterUpdateAction(this.toolbox, updateType, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), String.format("Continuing cluster %s", performingRollback ? "rollback" : "update"));
        this.queueProcessNotice(info);
        return cluster;
    }

    public Cluster cancel(String clusterId, Boolean rollback) {
        if (!this.managerLeader.isLeader()) {
            throw new ISE("Cannot cancel cluster update while not the manager leader", new Object[0]);
        }
        Cluster cluster = this.clusterDataManager.get(clusterId);
        Info existingInfo = this.toolbox.getEntityStateDataManager().getOrNull(cluster);
        Boolean skipAutoRollback = BooleanUtils.isFalse((Boolean)rollback);
        State cancelState = CancelClusterUpdateAction.getCancelState(existingInfo, skipAutoRollback);
        this.assertValidClusterStateChange(cluster, cancelState);
        if (State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)existingInfo.getDesiredState())) {
            throw new IAE("Cannot cancel update for cluster [%s] while rolling back", new Object[]{clusterId});
        }
        this.auditAction(cluster, new CancelClusterUpdateAction(this.toolbox, cluster.getClusterId(), skipAutoRollback, null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.toolbox.getNoticeManager().queueNoticeAndAwaitCompletion(new CancelClusterUpdateAction.CancelClusterUpdateNotice(this.toolbox, existingInfo, skipAutoRollback), true, 20000L);
        return cluster;
    }

    public Cluster rollback(String clusterId, UpdateType updateType) {
        Cluster cluster = this.clusterDataManager.get(clusterId);
        Info existingInfo = this.toolbox.getEntityStateDataManager().getOrNull(cluster);
        this.assertValidClusterStateChange(cluster, State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED);
        if (State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)existingInfo.getDesiredState())) {
            throw new IAE("Can't initiate a rollback while already performing a rollback for cluster [%s]", new Object[]{clusterId});
        }
        Info.Builder infoBuilder = cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().withState(State.CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED).withDesiredState(State.CLUSTER_UPDATE_ROLLED_BACK);
        if (updateType != null) {
            this.assertUpdateTypeChangeSupported(existingInfo, clusterId, updateType);
            infoBuilder.withUpdateType(updateType);
        }
        Info info = this.toolbox.getEntityStateDataManager().insert(cluster, infoBuilder.build());
        this.auditAction(cluster, new RollbackClusterUpdateAction(this.toolbox, updateType, cluster.getClusterId(), null, ThreadLocalContext.getPrincipal().getDetailedUserId()));
        this.clearNotifications(cluster.key());
        this.addInfoNotification(cluster.key(), "Cluster rollback requested");
        this.queueProcessNotice(info);
        return cluster;
    }

    public ClusterWithExtendedInfo getExtended(@NotNull String clusterId) {
        ThreadLocalContext.setNoticeOrActionClass(DescribeClusterAction.class);
        return DescribeClusterHelper.describeCluster(this.toolbox, clusterId, true);
    }

    public Cluster get(@NotNull String clusterId) {
        ThreadLocalContext.setNoticeOrActionClass(DescribeClusterAction.class);
        return this.clusterDataManager.get(clusterId);
    }

    public List<ClusterWithExtendedInfo> listExtended(@NotNull String accountId) {
        ThreadLocalContext.setNoticeOrActionClass(DescribeClustersAction.class);
        return this.clusterDataManager.getAllWithAccountId(accountId, DeletedVisibility.SHOW_RECENT).stream().map(cluster -> this.getExtended(cluster.getClusterId())).collect(Collectors.toList());
    }

    public List<Cluster> list(@NotNull String accountId) {
        ThreadLocalContext.setNoticeOrActionClass(DescribeClustersAction.class);
        return new ArrayList<Cluster>(this.clusterDataManager.getAllWithAccountId(accountId, DeletedVisibility.SHOW_RECENT));
    }

    public Cluster getVersion(@NotNull String clusterId, @NotNull Integer resourceVersion) {
        return this.clusterDataManager.getAllVersions(clusterId, DeletedVisibility.SHOW_RECENT).stream().filter(cluster -> cluster.getVersion().equals(resourceVersion)).findFirst().orElseThrow(() -> new ObjectNotFoundException("Cluster [%s] resource version [%s] was not found", new Object[]{clusterId, resourceVersion}));
    }

    private ImplyVersion getImplyVersion(Cluster cluster) {
        if (cluster.getImplyVersion() != null) {
            return this.getClusterImplyVersion(cluster);
        }
        return this.getCurrentImplyVersion(cluster);
    }

    private Optional<ImplyVersion> maybeGetClusterImplyVersion(Cluster cluster) {
        ImplyVersion implyVersion = this.toolbox.getImplyVersionHelper().lookupImplyVersionIncludingAccountVersions(cluster.getImplyVersion(), cluster.getAccountId(), this.toolbox.getClusterDataManager());
        return Optional.ofNullable(implyVersion);
    }

    private ImplyVersion getClusterImplyVersion(Cluster cluster) {
        return this.maybeGetClusterImplyVersion(cluster).orElseThrow(() -> new IAE("Unsupported implyVersion [%s]", new Object[]{cluster.getImplyVersion()}));
    }

    private ImplyVersion getCurrentImplyVersion(Cluster cluster) {
        return (ImplyVersion)this.toolbox.getImplyVersionHelper().getSupportedImplyVersionsIncludingAccountVersions(cluster.getAccountId(), this.toolbox.getClusterDataManager()).stream().findFirst().orElseThrow(() -> new IAE("No valid implyVersion found", new Object[0]));
    }

    private List<UpdateType> getSupportedUpdateTypes(List<UpdateDetails> updateDetails, UpdateType updateType) {
        return UpdateType.HARD.equals((Object)updateType) ? ImmutableList.of((Object)UpdateType.HARD) : updateDetails.stream().map(UpdateDetails::getType).collect(Collectors.toList());
    }

    private void assertICULimitNotExceeded(Account account, Cluster cluster) {
        int proposedTotalMICU = this.toolbox.getClusterUpdateHelper().getTotalMICU(account.getAccountId(), cluster);
        if (account.isValueExceedingIcuLimit(proposedTotalMICU)) {
            throw new IAE("ICU limit of [%d] would be exceeded", new Object[]{account.getIcuLimit()});
        }
    }

    private void assertValidAccountState(Account account) {
        Info accountInfo = this.toolbox.getEntityStateDataManager().get(account);
        if (!State.CREATED.equals((Object)accountInfo.getState().getExternalState(null))) {
            throw new ISE("Account [%s] is not created", new Object[]{account.getAccountId()});
        }
    }

    private void assertValidClusterStateChange(Cluster cluster, State state) {
        Info info = this.toolbox.getEntityStateDataManager().getOrNull(cluster);
        if (info != null && !state.getValidPreviousStates().contains(info.getState())) {
            throw new ISE("Cluster [%s] cannot transition from [%s] to [%s]", new Object[]{cluster.getClusterId(), info.getState().getExternalState(null), state.getExternalState(null)});
        }
    }

    private void assertUpdateSupported(List<UpdateDetails> updateDetails) {
        updateDetails.stream().filter(detail -> UpdateType.UNSUPPORTED.equals((Object)detail.getType())).findAny().ifPresent(detail -> {
            throw new IAE("Unsupported update parameters [%s]", new Object[]{detail.getDisplayText()});
        });
    }

    private void assertUpdateTypeSupported(List<UpdateDetails> updateDetails, UpdateType updateType) {
        updateDetails.stream().filter(detail -> updateType.equals((Object)detail.getType())).findAny().orElseThrow(() -> new UpdateTypeNotSupportedException(updateType));
    }

    private void assertUpdateTypeChangeSupported(Info existingInfo, String clusterId, UpdateType updateType) {
        if (existingInfo == null || existingInfo.getUpdateState() == null || existingInfo.getUpdateState().getSupportedTypes() == null || existingInfo.getUpdateType() == null) {
            throw new ISE("Can't retrieve update state for cluster [%s]", new Object[]{clusterId});
        }
        if (!existingInfo.getUpdateState().getSupportedTypes().contains(updateType)) {
            throw new IAE("[%s] is not a supported updateType for the current update", new Object[]{updateType});
        }
        if (UpdateType.HARD.equals((Object)existingInfo.getUpdateType()) && UpdateType.ROLLING.equals((Object)updateType)) {
            throw new IAE("Can't transition from a HARD to a ROLLING updateType", new Object[0]);
        }
    }

    private void clearNotifications(String entityKey) {
        this.toolbox.getNotificationDataManager().deleteNotificationsWithEntityKey(entityKey);
    }

    private void addInfoNotification(String entityKey, String message) {
        this.toolbox.getNotificationDataManager().insert(Notification.of((String)message, null, (Notification.Level)Notification.Level.INFO, (Notification.Source)Notification.Source.MANAGER, (String)entityKey));
    }

    private void queueProcessNotice(Info info) {
        if (this.managerLeader.isLeader()) {
            this.toolbox.getNoticeManager().queueProcessNotice(info);
        }
    }

    private Pair<Map<String, Object>, Map<String, Object>> getParameters(Cluster originalCluster, Cluster updatedCluster) {
        JSON json = new JSON(this.toolbox.getObjectMapper());
        Map originalFlat = JsonFlattener.flattenAsMap((String)json.toJson((Object)originalCluster.cloner().withoutNonUpdatableFields().withVersion(null).withImplyVersionFull(null).build()));
        Map updatedFlat = JsonFlattener.flattenAsMap((String)json.toJson((Object)updatedCluster.cloner().withoutNonUpdatableFields().withVersion(null).withImplyVersionFull(null).build()));
        MapDifference flatDiff = Maps.difference((Map)originalFlat, (Map)updatedFlat);
        Map originalParameters = flatDiff.entriesDiffering().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), ((MapDifference.ValueDifference)e.getValue()).leftValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map modifiedParameters = flatDiff.entriesDiffering().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), ((MapDifference.ValueDifference)e.getValue()).rightValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        originalParameters = JsonUnflattener.unflattenAsMap((String)json.toJson(originalParameters));
        modifiedParameters = JsonUnflattener.unflattenAsMap((String)json.toJson(modifiedParameters));
        originalParameters.remove("type");
        modifiedParameters.remove("type");
        return new ImmutablePair((Object)originalParameters, (Object)modifiedParameters);
    }

    private void auditAction(Cluster cluster, Action action) {
        this.auditDataManager.insert(new AuditEntry(ThreadLocalContext.getPrincipal().getDetailedUserId(), cluster.getAccountId(), ThreadLocalContext.getRequestId(), action.getClass().getSimpleName(), action.toString(), DateTime.now()));
    }

    @Inject
    @Generated
    public ClusterManager(ManagerToolbox toolbox, ClusterDataManager clusterDataManager, AccountDataManager accountDataManager, ManagerLeader managerLeader, AuditDataManager auditDataManager) {
        this.toolbox = toolbox;
        this.clusterDataManager = clusterDataManager;
        this.accountDataManager = accountDataManager;
        this.managerLeader = managerLeader;
        this.auditDataManager = auditDataManager;
    }

    public static final class UpdateTypeNotSupportedException
    extends IAE {
        private static final String TEXT = "Invalid updateType [%s] for this changeset";

        public UpdateTypeNotSupportedException(UpdateType type) {
            super(TEXT, new Object[]{type});
        }
    }
}

