/*
 * Decompiled with CFR 0.152.
 */
package io.imply.telemetry.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.imply.telemetry.Emitter;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import io.imply.telemetry.dropwizard.ReporterConfig;
import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.CustomMappingSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(TelemetryReporter.class);
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private final Emitter emitter;
    private final String prefix;
    private final SampleBuilder sampleBuilder;
    private final Map<String, Long> previousCount = new HashMap<String, Long>();

    private TelemetryReporter(Emitter emitter, MetricRegistry registry, String prefix, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, ReporterConfig reporterConfig) {
        super(registry, "imply-telemetry-reporter", filter, RATE_UNIT, DURATION_UNIT, executor, shutdownExecutorOnStop, Collections.emptySet());
        this.emitter = Objects.requireNonNull(emitter, "emitter cannot be null");
        this.prefix = prefix;
        if (reporterConfig.getMapperConfigs().isEmpty()) {
            this.sampleBuilder = new DefaultSampleBuilder();
        } else {
            List mapperConfigs = reporterConfig.getMapperConfigs().stream().filter(cfg -> cfg.getMatchField() != null && !cfg.getMatchField().isEmpty()).map(cfg -> {
                MapperConfig mapperConfig = new MapperConfig();
                mapperConfig.setMatch(cfg.getMatchField());
                mapperConfig.setName(cfg.getMatchName());
                mapperConfig.setLabels(cfg.getLabels());
                return mapperConfig;
            }).collect(Collectors.toList());
            this.sampleBuilder = new CustomMappingSampleBuilder(mapperConfigs);
        }
    }

    public static Builder builder(Emitter emitter, MetricRegistry registry) {
        return new Builder(emitter, registry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.emitGauge(this.prefix(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.emitCounter(this.prefix(entry.getKey()), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.emitHistogram(this.prefix(entry.getKey()), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.emitMetered(this.prefix(entry.getKey()), (Metered)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.emitTimer(this.prefix(entry.getKey()), (Timer)entry.getValue());
        }
    }

    private String prefix(String name) {
        return this.prefix == null ? name : this.prefix + name;
    }

    private void emitGauge(String name, Gauge<?> gauge) {
        double value = 1.0;
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            log.debug("Invalid type for Gauge {}: {}", (Object)name, (Object)obj.getClass().getName());
            return;
        }
        this.emit(name, value);
    }

    private void emitCounter(String name, Counter counter) {
        this.emitCounter(name, counter.getCount());
    }

    private void emitHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.emit(name, snapshot.getMin(), MetricAttribute.MIN);
        this.emit(name, snapshot.getMax(), MetricAttribute.MAX);
        this.emit(name, snapshot.getMean(), MetricAttribute.MEAN);
        this.emit(name, snapshot.getStdDev(), MetricAttribute.STDDEV);
        this.emitCounter(name, histogram.getCount());
        this.emit(name, snapshot.getMedian(), MetricAttribute.P50);
        this.emit(name, snapshot.get75thPercentile(), MetricAttribute.P75);
        this.emit(name, snapshot.get95thPercentile(), MetricAttribute.P95);
        this.emit(name, snapshot.get98thPercentile(), MetricAttribute.P98);
        this.emit(name, snapshot.get99thPercentile(), MetricAttribute.P99);
        this.emit(name, snapshot.get999thPercentile(), MetricAttribute.P999);
    }

    private void emitMetered(String name, Metered metered) {
        this.emitCounter(name, metered.getCount());
        this.emit(name, this.convertRate(metered.getOneMinuteRate()), MetricAttribute.M1_RATE);
        this.emit(name, this.convertRate(metered.getFiveMinuteRate()), MetricAttribute.M5_RATE);
        this.emit(name, this.convertRate(metered.getFifteenMinuteRate()), MetricAttribute.M15_RATE);
        this.emit(name, this.convertRate(metered.getMeanRate()), MetricAttribute.MEAN_RATE);
    }

    private void emitTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.emit(name, this.convertDuration(snapshot.getMin()), MetricAttribute.MIN);
        this.emit(name, this.convertDuration(snapshot.getMax()), MetricAttribute.MAX);
        this.emit(name, this.convertDuration(snapshot.getMean()), MetricAttribute.MEAN);
        this.emit(name, this.convertDuration(snapshot.getStdDev()), MetricAttribute.STDDEV);
        this.emit(name, this.convertDuration(snapshot.getMedian()), MetricAttribute.P50);
        this.emit(name, this.convertDuration(snapshot.get75thPercentile()), MetricAttribute.P75);
        this.emit(name, this.convertDuration(snapshot.get95thPercentile()), MetricAttribute.P95);
        this.emit(name, this.convertDuration(snapshot.get98thPercentile()), MetricAttribute.P98);
        this.emit(name, this.convertDuration(snapshot.get99thPercentile()), MetricAttribute.P99);
        this.emit(name, this.convertDuration(snapshot.get999thPercentile()), MetricAttribute.P999);
        this.emitMetered(name, (Metered)timer);
    }

    private void emitCounter(String name, long count) {
        this.emit(name, count, MetricAttribute.COUNT);
        long delta = count - this.previousCount.getOrDefault(name, 0L);
        this.emit(name, delta);
        this.previousCount.put(name, count);
    }

    private void emit(String name, Number value) {
        this.emitter.emit((Event)this.getMetric(this.createSample(name, value.doubleValue())));
    }

    private void emit(String name, Number value, MetricAttribute type) {
        this.emit(Event.name((String)name, (String[])new String[]{type.getCode()}), value);
    }

    private Collector.MetricFamilySamples.Sample createSample(String name, Double value) {
        return this.sampleBuilder.createSample(name, "", new ArrayList(), new ArrayList(), value.doubleValue());
    }

    private MetricEvent getMetric(Collector.MetricFamilySamples.Sample sample) {
        MetricEvent.Builder builder = MetricEvent.builder((String)sample.name, (Number)sample.value);
        for (int i = 0; i < sample.labelNames.size(); ++i) {
            builder.addAttribute(sample.labelNames.get(i), sample.labelValues.get(i));
        }
        return builder.build();
    }

    public static class Builder {
        private final Emitter emitter;
        private final MetricRegistry registry;
        private String prefix;
        private MetricFilter filter = MetricFilter.ALL;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop = true;
        private ReporterConfig reporterConfig = ReporterConfig.defaultConfig();

        private Builder(Emitter emitter, MetricRegistry registry) {
            this.emitter = emitter;
            this.registry = registry;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder reporterConfig(ReporterConfig reporterConfig) {
            this.reporterConfig = reporterConfig;
            return this;
        }

        public TelemetryReporter build() {
            return new TelemetryReporter(this.emitter, this.registry, this.prefix, this.filter, this.executor, this.shutdownExecutorOnStop, this.reporterConfig);
        }
    }
}

