/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.onprem.util.OnPremKubernetesClusterStackHelper;
import io.imply.cloud.util.ISE;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections4.MapUtils;

public class OnPremKubernetesConfigRequestBodyHelper {
    private final OnPremKubernetesClusterStackHelper onPremKubernetesClusterStackHelper;

    @Inject
    public OnPremKubernetesConfigRequestBodyHelper(OnPremKubernetesClusterStackHelper onPremKubernetesClusterStackHelper) {
        this.onPremKubernetesClusterStackHelper = onPremKubernetesClusterStackHelper;
    }

    public ConfigRequestBody withPrivateLoadBalancerIp(ConfigRequestBody configRequestBody) {
        Preconditions.checkNotNull((Object)configRequestBody);
        CloudResources resources = this.onPremKubernetesClusterStackHelper.getClusterDetails(configRequestBody.getClusterId(), true, false, true);
        if (resources == null) {
            throw new ISE("Could not fetch Cloud Resources for [%s]", new Object[]{configRequestBody.getClusterId()});
        }
        Map lbs = MapUtils.emptyIfNull((Map)resources.getLoadBalancers());
        if (!lbs.containsKey("queryInternal")) {
            throw new ISE("Internal LoadBalancer address not yet available for [%s]", new Object[]{configRequestBody.getClusterId()});
        }
        return configRequestBody.toBuilder().privateIpAddresses((List)ImmutableList.builder().addAll((Iterable)configRequestBody.getPrivateIpAddresses()).add((Object)((String)lbs.get("queryInternal"))).build()).build();
    }
}

