/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.inject.Inject;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.configurator.ConfiguratorManager;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.State;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.util.ExecUtils;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesUtils;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import lombok.Generated;

public class OnPremKubernetesClusterOperator
implements ClusterOperator {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesClusterOperator.class);
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ApplicationConfig applicationConfig;
    private final ConfiguratorManager configuratorManager;
    private final OnPremKubernetesManagerConfig onPremKubernetesManagerConfig;

    public ClusterOperationResult createCluster(Cluster cluster, Account account) {
        try {
            String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig);
            this.maybeCreateOrUpdateNamespace(clusterNamespace, account.getAccountId(), cluster.getClusterId());
            this.k8sUtilsProvider.getHelmUtils(cluster).installHelmChart(HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig), this.configuratorManager.generateClusterHelmValueOverrides(cluster, account), this.onPremKubernetesManagerConfig.getHelmChartLocation());
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to create cluster [%s].", new Object[]{cluster.getClusterId()});
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, e.getMessage());
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "cluster helm chart was just installed");
    }

    public ClusterOperationResult updateCluster(Cluster cluster, Account account) {
        try {
            String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig);
            this.maybeCreateOrUpdateNamespace(clusterNamespace, account.getAccountId(), cluster.getClusterId());
            this.k8sUtilsProvider.getHelmUtils(cluster).upgradeHelmChart(HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig), this.configuratorManager.generateClusterHelmValueOverrides(cluster, account), this.onPremKubernetesManagerConfig.getHelmChartLocation());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to update cluster [%s].", new Object[]{cluster.getClusterId()});
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, e.getMessage());
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "cluster helm chart was just upgraded");
    }

    public ClusterOperationResult deleteCluster(Cluster cluster) {
        try {
            this.k8sUtilsProvider.getHelmUtils(cluster).deleteHelmChart(HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig));
            this.maybeDeletePVCs(cluster);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete cluster [%s].", new Object[]{cluster.getClusterId()});
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, e.getMessage());
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "cluster helm chart was just deleted");
    }

    public ClusterOperationResult getClusterOperationStatus(Cluster cluster, State currentState) {
        try {
            switch (currentState) {
                case CREATING_CLUSTER_STACK: 
                case UPDATING_CLUSTER_STACK: 
                case CLUSTER_ROLLING_UPDATE_IN_PROGRESS: {
                    return this.getClusterCreateOrUpdateOperationStatus(cluster);
                }
                case DELETING_CLUSTER_STACK: {
                    return this.getClusterDeleteOperationStatus(cluster);
                }
            }
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, "unexpected state");
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to get cluster status [%s].", new Object[]{cluster.getClusterId()});
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, e.getMessage());
        }
    }

    protected void maybeCreateOrUpdateNamespace(String namespace, String accountId, String clusterId) {
    }

    private void maybeDeletePVCs(Cluster cluster) {
        if (!this.applicationConfig.isKubernetesMode() || this.applicationConfig.isSaaS() || this.applicationConfig.isIOW()) {
            return;
        }
        String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig);
        String clusterReleaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig);
        try {
            this.k8sUtilsProvider.getKubernetesUtils(cluster).deletePVCsForRelease(clusterNamespace, clusterReleaseName);
        }
        catch (Exception e) {
            log.warn("Failed to delete PVCs for cluster [%s], message: '%s'", new Object[]{cluster.getClusterId(), e.getMessage()});
        }
    }

    private ClusterOperationResult getClusterCreateOrUpdateOperationStatus(Cluster cluster) {
        try {
            String clusterReleaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig);
            String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig);
            KubernetesUtils kubernetesUtils = this.k8sUtilsProvider.getKubernetesUtils(cluster);
            HelmUtils helmUtils = this.k8sUtilsProvider.getHelmUtils(cluster);
            ExecUtils.ExecResult execResult = helmUtils.checkReleaseExists(clusterReleaseName, clusterNamespace);
            if (0 != execResult.getExitValue()) {
                log.warn(String.format("Error when retrieving info for helm chart release [%s] found for cluster [%s] (clusterId: [%s]). %s", clusterReleaseName, cluster.getName(), cluster.getClusterId(), execResult.getOutput()));
                return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, String.format("Error when retrieving info for helm chart release [%s] found for cluster [%s] (clusterId: [%s]). %s", clusterReleaseName, cluster.getName(), cluster.getClusterId(), execResult.getOutput()));
            }
            ClusterOperationResult deploymentsResult = kubernetesUtils.getDeploymentsStatus(clusterReleaseName, clusterNamespace);
            if (!ClusterOperationResult.Status.COMPLETE.equals((Object)deploymentsResult.getStatus())) {
                return deploymentsResult;
            }
            ClusterOperationResult statefulsetsResult = this.getStatefulSetStatus(kubernetesUtils, cluster, clusterReleaseName, clusterNamespace);
            if (!ClusterOperationResult.Status.COMPLETE.equals((Object)statefulsetsResult.getStatus())) {
                return statefulsetsResult;
            }
        }
        catch (KubernetesClientException e) {
            log.warn((Throwable)e, "Failure occurred while checking status of cluster [%s]. %s", new Object[]{cluster.getClusterId(), e.getMessage()});
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, e.getMessage());
        }
        catch (IOException | TimeoutException e) {
            log.warn((Throwable)e, "Failure occurred while checking status of cluster [%s]. %s", new Object[]{cluster.getClusterId(), e.getMessage()});
            return new ClusterOperationResult(ClusterOperationResult.Status.FAILED, e.getMessage());
        }
        catch (NullPointerException e) {
            log.warn((Throwable)e, "Failed to get cluster state [%s].", new Object[]{cluster.getClusterId()});
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, "Waiting for status");
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, "Operation Complete");
    }

    private ClusterOperationResult getClusterDeleteOperationStatus(Cluster cluster) {
        try {
            return this.getClusterPodsDeleteOperationStatus(cluster);
        }
        catch (KubernetesClientException e) {
            log.warn((Throwable)e, "Failure occurred while checking status of cluster [%s]. %s", new Object[]{cluster.getClusterId(), e.getMessage()});
            return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, e.getMessage());
        }
    }

    private ClusterOperationResult getClusterPodsDeleteOperationStatus(Cluster cluster) {
        List<Pod> pods = this.k8sUtilsProvider.getKubernetesUtils(cluster).getPodsOfClusterRelease(HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig));
        long remainingPodCount = pods.stream().filter(pod -> pod.getStatus() != null).filter(pod -> {
            if ("Failed".equalsIgnoreCase(pod.getStatus().getPhase())) {
                log.warn("pod [%s] in failed state. %s.", new Object[]{pod.getMetadata().getName(), pod.getStatus().toString()});
                return false;
            }
            return true;
        }).count();
        if (remainingPodCount == 0L) {
            return new ClusterOperationResult(ClusterOperationResult.Status.COMPLETE, "pods deleted");
        }
        return new ClusterOperationResult(ClusterOperationResult.Status.PENDING, String.format("[%d] pod%s still exists", remainingPodCount, remainingPodCount > 1L ? "s" : ""));
    }

    protected ClusterOperationResult getStatefulSetStatus(KubernetesUtils kubernetesUtils, Cluster cluster, String clusterReleaseName, String clusterNamespace) {
        return kubernetesUtils.getStatefulSetsStatus(clusterReleaseName, clusterNamespace, cluster.getDataInstanceTiers().values().stream().mapToInt(InstanceTier::getInstanceCount).sum() == 0);
    }

    @Inject
    @Generated
    public OnPremKubernetesClusterOperator(K8sUtilsProvider k8sUtilsProvider, ApplicationConfig applicationConfig, ConfiguratorManager configuratorManager, OnPremKubernetesManagerConfig onPremKubernetesManagerConfig) {
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.applicationConfig = applicationConfig;
        this.configuratorManager = configuratorManager;
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
    }
}

