/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.KubernetesUtils;

public class OnPremK8sUtilsProvider
implements K8sUtilsProvider {
    private KubernetesUtils kubernetesUtils;
    private HelmUtils helmUtils;
    private KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();

    @Inject
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public OnPremK8sUtilsProvider(OnPremKubernetesManagerConfig onPremKubernetesManagerConfig) {
        this.kubernetesUtils = new KubernetesUtils(this.kubernetesClient);
        this.helmUtils = new HelmUtils(onPremKubernetesManagerConfig);
    }

    @Override
    public KubernetesUtils getKubernetesUtils(Account account) {
        return this.kubernetesUtils;
    }

    @Override
    public KubernetesUtils getKubernetesUtilsFromAccount(String accountId) {
        return this.kubernetesUtils;
    }

    @Override
    public HelmUtils getHelmUtils(Account account) {
        return this.helmUtils;
    }

    @Override
    public HelmUtils getHelmUtilsFromAccount(String accountId) {
        return this.helmUtils;
    }

    @Override
    public KubernetesUtils getKubernetesUtils(Cluster cluster) {
        return this.kubernetesUtils;
    }

    @Override
    public KubernetesUtils getKubernetesUtilsFromCluster(String clusterId) {
        return this.kubernetesUtils;
    }

    @Override
    public HelmUtils getHelmUtils(Cluster cluster) {
        return this.helmUtils;
    }

    @Override
    public HelmUtils getHelmUtilsFromCluster(String clusterId) {
        return this.helmUtils;
    }

    @Override
    public KubernetesClient getKubernetesClient(Account account) {
        return this.kubernetesClient;
    }

    @Override
    public KubernetesClient getKubernetesClientFromAccount(String accountId) {
        return this.kubernetesClient;
    }

    @Override
    public KubernetesClient getKubernetesClient(Cluster cluster) {
        return this.kubernetesClient;
    }

    @Override
    public KubernetesClient getKubernetesClientFromCluster(String clusterId) {
        return this.kubernetesClient;
    }

    @Override
    public KubernetesClient getDefaultKubernetesClient() {
        return this.kubernetesClient;
    }
}

